/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.events.servicestarted;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Map;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceState;

public class Test1108108Test
extends AbstractSleeTCKTest {
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    private static final int defaultTimeout = 25000;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private static final int expectedCount = 2;
    private int receivedCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        this.getLog().fine("Installing and activating service1");
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.getLog().fine("Installing service2");
        String duPath = this.utils().getTestParams().getProperty(SERVICE2_DU_PATH_PARAM);
        DeployableUnitID duID = this.utils().install(duPath);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        ServiceManagementMBeanProxy serviceProxy = this.utils().getServiceManagementMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(duID);
        ComponentID[] components = duDesc.getComponents();
        ServiceID firstService = null;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ServiceID)) continue;
            ServiceID service = (ServiceID)components[i];
            if (firstService != null) continue;
            firstService = service;
        }
        if (firstService == null) {
            result.setError("Failed to find the second test services.");
            return;
        }
        this.getLog().fine("Activating service2");
        serviceProxy.activate(firstService);
        ServiceID[] services = serviceProxy.getServices(ServiceState.ACTIVE);
        if (services.length != 2 || !Arrays.asList(services).contains(firstService)) {
            result.setFailed(1108108, "Failed to find two active service: found" + services.length + " instead.");
            return;
        }
        if (!firstService.getName().contains("Service2") || firstService.getName().contains("Service1")) {
            result.setFailed(1108109, "Failed to deliver the event to the root SBB of the activating Test1108108Service2, it was delivered to SBBs in any other Test1108108Service1 that was listening for the event type.");
            return;
        }
        this.getLog().fine("The service " + firstService + " is in Active state");
        Test1108108Test test1108108Test = this;
        synchronized (test1108108Test) {
            this.wait(25000L);
        }
        if (this.receivedCount == 2) {
            result.setPassed();
        } else {
            result.setFailed(1108108, "Expected number of successful messages not received, messages werenot delivered by the SBBs (expected 2, received " + this.receivedCount + ")");
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1108108Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1108108Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1108108Test.this.receivedCount++;
            }
            catch (TCKTestFailureException ex) {
                Test1108108Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1108108Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1108108Test.this.getLog().warning(exception);
            Test1108108Test.this.result.setError(exception);
        }
    }
}

