/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.activitycontextnamingfacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.Map;

public class ActivityContextNamingFacilityTest
extends AbstractSleeTCKTest {
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private String testName;

    public void run(FutureResult result) throws Exception {
        this.result = result;
        String activityName = "ActivityContextNamingFacilityTest";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: " + this.testName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.testName = this.utils().getTestParams().getProperty("testName");
        if (this.testName.equals("bindRefCount")) {
            String eventDUPath = this.utils().getTestParams().getProperty("eventDUPath");
            this.utils().install(eventDUPath);
        }
        this.setupService("serviceDUPath", true);
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = (String)sbbData.get("testname");
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            ActivityContextNamingFacilityTest.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                if (sbbTestName.equals(ActivityContextNamingFacilityTest.this.testName)) {
                    Assert.assertEquals(assertionID, "Test " + ActivityContextNamingFacilityTest.this.testName + " failed.", "pass", sbbTestResult);
                    ActivityContextNamingFacilityTest.this.result.setPassed();
                } else {
                    ActivityContextNamingFacilityTest.this.result.setError("Invalid response sent by SBB: " + sbbTestName);
                }
            }
            catch (TCKTestFailureException ex) {
                ActivityContextNamingFacilityTest.this.result.setFailed(ex);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            ActivityContextNamingFacilityTest.this.getLog().warning("Received Exception from SBB or resource:");
            ActivityContextNamingFacilityTest.this.getLog().warning(exception);
            ActivityContextNamingFacilityTest.this.result.setError(exception);
        }
    }
}

