/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.activitycontextnamingfacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.ComponentID;
import javax.slee.InitialEventSelector;
import javax.slee.SbbContext;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.Level;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;

public abstract class UnbindRefCountSbb
extends BaseTCKSbb {
    private NullActivityFactory nullActivityFactory;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private ActivityContextNamingFacility acNamingFacility;
    private boolean result = false;
    private String message;
    private int failedAssertionID = -1;

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.nullActivityFactory = (NullActivityFactory)myEnv.lookup("slee/nullactivity/factory");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)myEnv.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.acNamingFacility = (ActivityContextNamingFacility)myEnv.lookup("slee/facilities/activitycontextnaming");
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received start message", null);
            this.setTestName((String)event.getMessage());
            NullActivity nobody = this.nullActivityFactory.createNullActivity();
            ActivityContextInterface nobodyACI = this.nullACIFactory.getActivityContextInterface(nobody);
            this.acNamingFacility.bind(nobodyACI, "unbind-test");
            this.acNamingFacility.unbind("unbind-test");
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        try {
            if (aci.getActivity() instanceof NullActivity) {
                TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received NullActivity end event", null);
                this.setResultPassed("unbind() decremented aci ref count correctly");
                this.sendResultToTCK();
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public InitialEventSelector getStaticConvergenceName(InitialEventSelector ies) {
        ies.setCustomName("foobar");
        return ies;
    }

    public abstract void setTestName(String var1);

    public abstract String getTestName();

    private void sendResultToTCK() throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", this.getTestName());
        sbbData.put("result", this.result ? "pass" : "fail");
        sbbData.put("message", this.message);
        sbbData.put("id", new Integer(this.failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private void setResultFailed(int assertionID, String msg) throws Exception {
        this.result = false;
        this.failedAssertionID = assertionID;
        this.message = "Assertion " + assertionID + " failed: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, this.message, null);
    }

    private void setResultPassed(String msg) throws Exception {
        this.result = true;
        this.message = "Success: " + msg;
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, this.message, null);
    }
}

