/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.management.AlarmNotification;
import javax.slee.management.DeployableUnitID;

public class Test1113484Test
extends AbstractSleeTCKTest {
    private TCKResourceListener resourceListener;
    private NotificationListener listener;
    private DeployableUnitID duID;
    private AlarmMBeanProxy alarmMBeanProxy;
    private FutureResult result;
    private int receivedAlarmNotifications = 0;
    private static int expectedAlarmNotifications = 15;
    private String testName = "Test1113484";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        String activityName = "Test1113484Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: " + this.testName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
        Test1113484Test test1113484Test = this;
        synchronized (test1113484Test) {
            this.wait(this.utils().getTestTimeout());
        }
        if (expectedAlarmNotifications == this.receivedAlarmNotifications) {
            result.setPassed();
        } else {
            result.setFailed(1113484, "Expected number of alarm messages not received, alarms were not delivered by the AlarmFacility (expected " + expectedAlarmNotifications + ", received " + this.receivedAlarmNotifications + ")");
        }
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        this.alarmMBeanProxy = this.utils().getAlarmMBeanProxy();
        this.listener = new AlarmNotificationListenerImpl();
        this.alarmMBeanProxy.addNotificationListener(this.listener, null, null);
    }

    public void tearDown() throws Exception {
        String[] listActiveAlarms = this.alarmMBeanProxy.getAlarms();
        if (this.alarmMBeanProxy.getAlarms().length > 0) {
            for (int i = 0; i < listActiveAlarms.length; ++i) {
                this.alarmMBeanProxy.clearAlarm(listActiveAlarms[i]);
            }
        }
        if (null != this.alarmMBeanProxy) {
            this.alarmMBeanProxy.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AlarmNotification) {
                AlarmNotification alarmNotification = (AlarmNotification)notification;
                Test1113484Test.this.getLog().fine("Received javax.slee.management.alarm.sbb");
                if (alarmNotification.getType().equals("javax.slee.management.alarm.sbb")) {
                    if (alarmNotification.getMessage().equals("CRITICAL:Test1113484AlarmMessage")) {
                        Test1113484Test.this.receivedAlarmNotifications = Test1113484Test.this.receivedAlarmNotifications + 1;
                    } else if (alarmNotification.getMessage().equals("MAJOR:Test1113484AlarmMessage")) {
                        Test1113484Test.this.receivedAlarmNotifications = Test1113484Test.this.receivedAlarmNotifications + 2;
                    } else if (alarmNotification.getMessage().equals("WARNING:Test1113484AlarmMessage")) {
                        Test1113484Test.this.receivedAlarmNotifications = Test1113484Test.this.receivedAlarmNotifications + 3;
                    } else if (alarmNotification.getMessage().equals("INDETERMINATE:Test1113484AlarmMessage")) {
                        Test1113484Test.this.receivedAlarmNotifications = Test1113484Test.this.receivedAlarmNotifications + 4;
                    } else if (alarmNotification.getMessage().equals("MINOR:Test1113484AlarmMessage")) {
                        Test1113484Test.this.receivedAlarmNotifications = Test1113484Test.this.receivedAlarmNotifications + 5;
                    }
                }
                return;
            }
            Test1113484Test.this.getLog().info("Notification received: " + notification);
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1113484Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1113484Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1113484Test.this.result.setPassed();
            }
            catch (TCKTestFailureException ex) {
                Test1113484Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1113484Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1113484Test.this.getLog().warning(exception);
            Test1113484Test.this.result.setError(exception);
        }
    }
}

