/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.facilities.AlarmLevel;
import javax.slee.management.AlarmNotification;

public class Test1113506Test
extends AbstractSleeTCKTest {
    public static final String SERVICE1_DU_PATH_PARAM = "service1DUPath";
    public static final String SERVICE2_DU_PATH_PARAM = "service2DUPath";
    private AlarmMBeanProxy alarmMBeanProxy;
    private TCKResourceListener resourceListener;
    private NotificationListener listener;
    private FutureResult result;
    private String testName = "Test1113506";
    private int expectedAlarmNotifications;
    private int receivedAlarmNotifications;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        this.receivedAlarmNotifications = 0;
        this.expectedAlarmNotifications = 15;
        String activityName = "Test1113506Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y1", this.testName, activityID, null);
        Test1113506Test test1113506Test = this;
        synchronized (test1113506Test) {
            this.wait(3000L);
        }
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventY.Y2", this.testName, activityID, null);
        test1113506Test = this;
        synchronized (test1113506Test) {
            this.wait(this.utils().getTestTimeout() - 3000);
        }
        Assert.assertTrue(1113506, "Expected number of Alarm messages not received, Alarms were not delivered by the AlarmFacility (expected " + this.expectedAlarmNotifications + ", received " + this.receivedAlarmNotifications + ")", this.expectedAlarmNotifications == this.receivedAlarmNotifications);
        result.setPassed();
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.getLog().fine("Installing and activating service");
        this.setupService(SERVICE1_DU_PATH_PARAM, true);
        this.setupService(SERVICE2_DU_PATH_PARAM, true);
        this.alarmMBeanProxy = this.utils().getAlarmMBeanProxy();
        this.listener = new AlarmNotificationListenerImpl();
        this.alarmMBeanProxy.addNotificationListener(this.listener, null, null);
    }

    public void tearDown() throws Exception {
        String[] listActiveAlarms = this.alarmMBeanProxy.getAlarms();
        if (this.alarmMBeanProxy.getAlarms().length > 0) {
            for (int i = 0; i < listActiveAlarms.length; ++i) {
                this.alarmMBeanProxy.clearAlarm(listActiveAlarms[i]);
            }
        }
        if (null != this.alarmMBeanProxy) {
            this.alarmMBeanProxy.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AlarmNotification) {
                AlarmNotification alarmNotification = (AlarmNotification)notification;
                if (alarmNotification.getMessage().equals("Test1113506AlarmMessageSbb1")) {
                    Test1113506Test.this.receivedAlarmNotifications++;
                } else if (alarmNotification.getMessage().equals("Test1113506AlarmMessageSbb2")) {
                    Test1113506Test.this.receivedAlarmNotifications++;
                    if (alarmNotification.getAlarmLevel().equals((Object)AlarmLevel.CLEAR) && Test1113506Test.this.receivedAlarmNotifications >= 5) {
                        Test1113506Test.this.result.setFailed(1113506, "Received the raised alarm been cleared from Test1113506Sbb2, which is not expected!" + Test1113506Test.this.receivedAlarmNotifications);
                        return;
                    }
                } else {
                    Test1113506Test.this.result.setFailed(1113506, "Message in AlarmNotification was not that set in AlarmFacility.raiseAlarm()");
                }
                return;
            }
            Test1113506Test.this.getLog().info("Notification received: " + notification);
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1113506Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1113506Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
            }
            catch (TCKTestFailureException ex) {
                Test1113506Test.this.result.setFailed(assertionID, sbbTestMessage);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1113506Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1113506Test.this.getLog().warning(exception);
            Test1113506Test.this.result.setError(exception);
        }
    }
}

