/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.alarmfacility.alarm;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.AlarmLevel;
import javax.slee.facilities.Tracer;

public abstract class Test1113467Sbb
extends BaseTCKSbb {
    private static final String JNDI_ALARMFACILITY_NAME = "java:comp/env/slee/facilities/alarm";
    public static final String ALARM_MESSAGE = "Test1113467AlarmMessage";
    public static final String ALARM_INSTANCEID = "Test1113467AlarmInstanceID";
    private Tracer tracer;

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Recieved " + event + " message");
            AlarmFacility facility = (AlarmFacility)new InitialContext().lookup(JNDI_ALARMFACILITY_NAME);
            this.setFirstAlarm(facility.raiseAlarm("javax.slee.management.Alarm", ALARM_INSTANCEID, AlarmLevel.MAJOR, ALARM_MESSAGE));
            if (!facility.clearAlarm(this.getFirstAlarm())) {
                this.tracer.severe("The first alarm which was raised cannot be cleared!");
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX2(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Recieved " + event + " message");
            AlarmFacility facility = (AlarmFacility)new InitialContext().lookup(JNDI_ALARMFACILITY_NAME);
            this.setSecondAlarm(facility.raiseAlarm("javax.slee.management.Alarm", ALARM_INSTANCEID, AlarmLevel.MAJOR, ALARM_MESSAGE));
            if (this.getSecondAlarm().equals(this.getFirstAlarm())) {
                this.sendResultToTCK("Test1113467Test", false, 1113467, " The alarm is raised didn't distinguish by different alarm identifiers.");
            }
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX3(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            String alarmID;
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Recieved " + event + " message");
            AlarmFacility facility = (AlarmFacility)new InitialContext().lookup(JNDI_ALARMFACILITY_NAME);
            if (!facility.clearAlarm(this.getSecondAlarm())) {
                this.tracer.severe("The second alarm which was raised cannot be cleared!");
            }
            if ((alarmID = facility.raiseAlarm("javax.slee.management.Alarm", ALARM_INSTANCEID, AlarmLevel.MAJOR, ALARM_MESSAGE)).equals(this.getSecondAlarm())) {
                this.sendResultToTCK("Test1113467Test", false, 1113467, " The alarm is raised didn't distinguish by different alarm identifiers again.");
            }
            this.sendResultToTCK("Test1113467Test", true, 1113467, "The alarm is raised are distinguished by different alarm identifiers test passed.");
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResultToTCK(String testName, boolean result, int failedAssertionID, String message) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    public abstract void setFirstAlarm(String var1);

    public abstract String getFirstAlarm();

    public abstract void setSecondAlarm(String var1);

    public abstract String getSecondAlarm();
}

