/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.profilefacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.testsuite.facilities.profilefacility.ProfileFacilityTestProfileCMP;
import com.opencloud.sleetck.lib.testsuite.facilities.profilefacility.SendResultEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.ComponentID;
import javax.slee.facilities.Level;
import javax.slee.profile.AttributeNotIndexedException;
import javax.slee.profile.AttributeTypeMismatchException;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileID;
import javax.slee.profile.UnrecognizedAttributeException;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public abstract class ProfileFacilityTestSbb
extends BaseTCKSbb {
    private static final String JNDI_PROFILEFACILITY_NAME = "java:comp/env/slee/facilities/profile";

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.setTestName((String)event.getMessage());
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "Received " + this.getTestName() + " message", null);
            if (this.getTestName().equals("jndi")) {
                this.doJNDITest();
            } else if (this.getTestName().equals("exception")) {
                this.doExceptionTest();
            } else if (this.getTestName().equals("getProfiles")) {
                this.doGetProfilesTest();
            } else if (this.getTestName().equals("getProfile")) {
                this.doGetProfileTest();
            } else if (this.getTestName().equals("getProfilesIterator")) {
                this.doGetProfilesIteratorTest();
            }
            this.fireSendResultEvent(new SendResultEvent(), aci, null);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onSendResultEvent(SendResultEvent event, ActivityContextInterface aci) {
        try {
            this.sendResultToTCK();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void doJNDITest() throws Exception {
        ProfileFacility pf = this.getProfileFacility();
        if (pf != null) {
            this.setResultPassed("Found ProfileFacility object in JNDI at java:comp/env/slee/facilities/profile");
        } else {
            this.setResultFailed(1414, "Could not find ProfileFacility object in JNDI at java:comp/env/slee/facilities/profile");
        }
    }

    private void sendResultToTCK() throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", this.getTestName());
        sbbData.put("result", this.getResult() ? "pass" : "fail");
        sbbData.put("message", this.getMessage());
        sbbData.put("id", new Integer(this.getFailedAssertionID()));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private void setResultFailed(int assertionID, String msg) throws Exception {
        this.setResult(false);
        this.setFailedAssertionID(assertionID);
        this.setMessage("Assertion " + assertionID + " failed: " + msg);
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, this.getMessage(), null);
    }

    private void setResultPassed(String msg) throws Exception {
        this.setResult(true);
        this.setMessage("Success: " + msg);
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, this.getMessage(), null);
    }

    private void doExceptionTest() throws Exception {
        ProfileFacility pf = this.getProfileFacility();
        try {
            pf.getProfilesByIndexedAttribute(null, "attr1", (Object)new Integer(0));
            this.setResultFailed(1393, "getProfilesByIndexedAttribute with null profileTableName did not throw NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1393, "getProfilesByIndexedAttribute with null profileTableName threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfilesByIndexedAttribute("ProfileFacilityTestTable", null, (Object)new Integer(0));
            this.setResultFailed(1393, "getProfilesByIndexedAttribute with null attributeName did not throw NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1393, "getProfilesByIndexedAttribute with null attributeName threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfilesByIndexedAttribute("ProfileFacilityTestTable", "attr1", null);
            this.setResultFailed(1393, "getProfilesByIndexedAttribute with null attributeValue did not throw NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1393, "getProfilesByIndexedAttribute with null attributeValue threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfileByIndexedAttribute(null, "attr1", (Object)new Integer(0));
            this.setResultFailed(1393, "getProfileByIndexedAttribute with null profileTableName did not throw NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1393, "getProfileByIndexedAttribute with null profileTableName threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfileByIndexedAttribute("ProfileFacilityTestTable", null, (Object)new Integer(0));
            this.setResultFailed(1393, "getProfileByIndexedAttribute with null attributeName did not throw NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1393, "getProfileByIndexedAttribute with null attributeName threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfileByIndexedAttribute("ProfileFacilityTestTable", "attr1", null);
            this.setResultFailed(1393, "getProfileByIndexedAttribute with null attributeValue did not throw NullPointerException");
            return;
        }
        catch (NullPointerException npe) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1393, "getProfileByIndexedAttribute with null attributeValue threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfilesByIndexedAttribute("ThisTableDoesNotExist", "attr1", (Object)new Integer(0));
            this.setResultFailed(1390, "getProfilesByIndexedAttribute with non-existent profileTableName did not throw UnrecognizedProfileTableNameException");
            return;
        }
        catch (UnrecognizedProfileTableNameException uptne) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected UnrecognizedProfileTableNameException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1390, "getProfilesByIndexedAttribute with non-existent profileTableName threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfileByIndexedAttribute("ThisTableDoesNotExist", "attr1", (Object)new Integer(0));
            this.setResultFailed(1390, "getProfileByIndexedAttribute with non-existent profileTableName did not throw UnrecognizedProfileTableNameException");
            return;
        }
        catch (UnrecognizedProfileTableNameException uptne) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected UnrecognizedProfileTableNameException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1390, "getProfileByIndexedAttribute with non-existent profileTableName threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfilesByIndexedAttribute("ProfileFacilityTestTable", "thisAttrDoesNotExist", (Object)"ProfileFacilityTest");
            this.setResultFailed(1391, "getProfilesByIndexedAttribute with non-existent attributeName did not throw UnrecognizedProfileTableNameException");
            return;
        }
        catch (UnrecognizedAttributeException uae) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected UnrecognizedAttributeException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1391, "getProfilesByIndexedAttribute with non-existent attributeName threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfileByIndexedAttribute("ProfileFacilityTestTable", "thisAttrDoesNotExist", (Object)"ProfileFacilityTest");
            this.setResultFailed(1391, "getProfileByIndexedAttribute with non-existent attributeName did not throw UnrecognizedProfileTableNameException");
            return;
        }
        catch (UnrecognizedAttributeException uae) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected UnrecognizedProfileTableNameException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1391, "getProfileByIndexedAttribute with non-existent attributeName threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfilesByIndexedAttribute("ProfileFacilityTestTable", "attr3", (Object)"ProfileFacilityTest");
            this.setResultFailed(1392, "getProfilesByIndexedAttribute with non-indexed attribute did not throw AttributeNotIndexedException");
            return;
        }
        catch (AttributeNotIndexedException anie) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected AttributeNotIndexedException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1392, "getProfilesByIndexedAttribute with non-indexed attribute threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfileByIndexedAttribute("ProfileFacilityTestTable", "attr3", (Object)"ProfileFacilityTest");
            this.setResultFailed(1392, "getProfileByIndexedAttribute with non-indexed attribute did not throw AttributeNotIndexedException");
            return;
        }
        catch (AttributeNotIndexedException anie) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected AttributeNotIndexedException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1392, "getProfileByIndexedAttribute with non-indexed attribute threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfilesByIndexedAttribute("ProfileFacilityTestTable", "attr1", (Object)"foo");
            this.setResultFailed(1389, "getProfilesByIndexedAttribute with inappropriate attributeValue type did not throw InvalidArgumentException");
            return;
        }
        catch (AttributeTypeMismatchException iae) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected InvalidArgumentException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1389, "getProfilesByIndexedAttribute with inappropriate attributeValue type threw unexpected exception: " + e);
            return;
        }
        try {
            pf.getProfileByIndexedAttribute("ProfileFacilityTestTable", "attr1", (Object)"foo");
            this.setResultFailed(1389, "getProfileByIndexedAttribute with inappropriate attributeValue type did not throw InvalidArgumentException");
            return;
        }
        catch (AttributeTypeMismatchException iae) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected InvalidArgumentException", null);
        }
        catch (Exception e) {
            this.setResultFailed(1389, "getProfileByIndexedAttribute with inappropriate attributeValue type threw unexpected exception: " + e);
            return;
        }
        Collection collection = pf.getProfiles("ProfileFacilityTestTable");
        Iterator it = collection.iterator();
        ProfileID id = (ProfileID)it.next();
        try {
            it.remove();
            this.setResultFailed(4452, "Iterator returned by getProfiles did not throw UnsupportedOperationException on remove()");
            return;
        }
        catch (UnsupportedOperationException e) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected UnsupportedOperationException", null);
        }
        catch (Exception e) {
            this.setResultFailed(4452, "Iterator returned by getProfiles threw unexpected exception on remove(): " + e);
            return;
        }
        try {
            this.getProfileFacilityTestProfile(id);
        }
        catch (UnrecognizedProfileNameException e) {
            this.setResultFailed(4452, "Iterator returned by getProfiles did not throw UnsupportedOperationException on remove(), and removed the profile");
        }
        try {
            pf.getProfiles(null);
            this.setResultFailed(4453, "getProfiles with null profile table name did not throw null pointer exception");
        }
        catch (NullPointerException e) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected NullPointerException", null);
        }
        catch (Exception e) {
            this.setResultFailed(4453, "getProfiles with null profile table name threw unexpected exception: " + e);
        }
        try {
            pf.getProfiles("ProfileThatDoesNotExist");
            this.setResultFailed(4454, "getProfiles with non existant table name did not throw UnrecognizedProfileTableNameException");
        }
        catch (UnrecognizedProfileTableNameException e) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "got expected UnrecognizedProfileTableNameException", null);
        }
        catch (Exception e) {
            this.setResultFailed(4454, "getProfiles with non existant table name threw unexpected exception: " + e);
        }
        this.setResultPassed("ProfileFacility exception tests passed");
    }

    private void doGetProfilesIteratorTest() throws Exception {
        ProfileFacility pf = this.getProfileFacility();
        Iterator it = pf.getProfiles("ProfileFacilityTestTable2").iterator();
        int count = 0;
        while (it.hasNext()) {
            try {
                ProfileID id = (ProfileID)it.next();
                if (!id.getProfileTableName().equals("ProfileFacilityTestTable2")) {
                    this.setResultFailed(4448, "getProfiles() returned a profile from another profile table");
                }
                ++count;
            }
            catch (ClassCastException e) {
                this.setResultFailed(4451, "Iterator returned by getProfiles() contained elements of type other than ProfileID");
                return;
            }
        }
        if (count < 2) {
            this.setResultFailed(4448, "Iterator returned by getProfiles did not contain all profiles in the profile table, expected: 2, got " + count);
            return;
        }
        if (count > 2) {
            this.setResultFailed(4448, "Iterator returned by getProfiles returned too many profiles, expected: 2, got " + count);
            return;
        }
        it = pf.getProfiles("ProfileFacilityTestTable3").iterator();
        if (it.hasNext()) {
            this.setResultFailed(4448, "Iterator returned by getProfiles() on a profile table with no profles was not empty");
            return;
        }
        this.setResultPassed("Profile facility getProfiles() Iterator tests passed");
    }

    private void doGetProfilesTest() throws Exception {
        ProfileFacilityTestProfileCMP profile;
        ProfileID profileID;
        ProfileFacility pf = this.getProfileFacility();
        Iterator it = pf.getProfilesByIndexedAttribute("ProfileFacilityTestTable", "attr1", (Object)new Integer(1)).iterator();
        boolean found = false;
        while (it.hasNext()) {
            profileID = (ProfileID)it.next();
            profile = this.getProfileFacilityTestProfile(profileID);
            if (1 != profile.getAttr1()) {
                this.setResultFailed(1383, "returned profile did not match search criteria (non-array attribute)");
                return;
            }
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "getProfilesByIndexedAttribute found profile (non-array attribute)", null);
            found = true;
        }
        if (!found) {
            this.setResultFailed(1383, "getProfilesByIndexedAttribute did not find profile (non-array attribute)");
            return;
        }
        it = pf.getProfilesByIndexedAttribute("ProfileFacilityTestTable", "attr2", (Object)new Integer(2)).iterator();
        found = false;
        if (it.hasNext()) {
            profileID = (ProfileID)it.next();
            profile = this.getProfileFacilityTestProfile(profileID);
            int[] attr2 = profile.getAttr2();
            for (int i = 0; i < attr2.length; ++i) {
                if (2 != attr2[i]) continue;
                found = true;
                TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "getProfilesByIndexedAttribute found profile (array attribute)", null);
                break;
            }
            if (!found) {
                this.setResultFailed(1386, "returned profile did not match search criteria (array attribute)");
                return;
            }
        }
        if (!found) {
            this.setResultFailed(1386, "getProfilesByIndexedAttribute did not find profile (array attribute)");
            return;
        }
        this.setResultPassed("getProfilesByIndexedAttribute tests passed");
    }

    private void doGetProfileTest() throws Exception {
        ProfileFacility pf = this.getProfileFacility();
        ProfileID profileID = pf.getProfileByIndexedAttribute("ProfileFacilityTestTable", "attr1", (Object)new Integer(1));
        if (profileID == null) {
            this.setResultFailed(1383, "getProfileByIndexedAttribute returned no profiles (non-array attribute)");
            return;
        }
        ProfileFacilityTestProfileCMP profile = this.getProfileFacilityTestProfile(profileID);
        if (1 != profile.getAttr1()) {
            this.setResultFailed(1383, "returned profile did not match search criteria (non-array attribute)");
            return;
        }
        TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "getProfileByIndexedAttribute found profile (non-array attribute)", null);
        profileID = pf.getProfileByIndexedAttribute("ProfileFacilityTestTable", "attr1", (Object)new Integer(1));
        if (profileID == null) {
            this.setResultFailed(1386, "getProfileByIndexedAttribute returned no profiles (array attribute)");
            return;
        }
        profile = this.getProfileFacilityTestProfile(profileID);
        int[] attr2 = profile.getAttr2();
        boolean found = false;
        for (int i = 0; i < attr2.length; ++i) {
            if (2 != attr2[i]) continue;
            found = true;
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.INFO, "getProfileByIndexedAttribute found profile (array attribute)", null);
            break;
        }
        if (!found) {
            this.setResultFailed(1386, "returned profile did not match search criteria (array attribute)");
            return;
        }
        ProfileID nullProfileID = pf.getProfileByIndexedAttribute("ProfileFacilityTestTable", "attr1", (Object)new Integer(999));
        if (nullProfileID != null) {
            this.setResultFailed(1396, "getProfileByIndexedAttribute did not return null for failed search");
            return;
        }
        this.setResultPassed("getProfileByIndexedAttribute tests passed");
    }

    private ProfileFacility getProfileFacility() throws Exception {
        ProfileFacility pf = null;
        try {
            pf = (ProfileFacility)new InitialContext().lookup(JNDI_PROFILEFACILITY_NAME);
        }
        catch (Exception e) {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.WARNING, "got unexpected Exception: " + e, null);
        }
        return pf;
    }

    public abstract ProfileFacilityTestProfileCMP getProfileFacilityTestProfile(ProfileID var1) throws UnrecognizedProfileTableNameException, UnrecognizedProfileNameException;

    public abstract void fireSendResultEvent(SendResultEvent var1, ActivityContextInterface var2, Address var3);

    public abstract boolean getResult();

    public abstract void setResult(boolean var1);

    public abstract String getMessage();

    public abstract void setMessage(String var1);

    public abstract String getTestName();

    public abstract void setTestName(String var1);

    public abstract int getFailedAssertionID();

    public abstract void setFailedAssertionID(int var1);
}

