/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.profilefacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.testsuite.facilities.profilefacility.Test1113032ProfileCMP;
import com.opencloud.sleetck.lib.testsuite.facilities.profilefacility.Test1113032ProfileTable;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.facilities.Tracer;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileTable;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public abstract class Test1113032Sbb
extends BaseTCKSbb {
    private static final String JNDI_PROFILEFACILITY_NAME = "java:comp/env/slee/facilities/profile";
    public static final String PROFILE_TABLE_NAME = "Test1113032ProfileTable";
    public static final String PROFILE_NAME = "Test1113032Profile";
    private Tracer tracer;

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.tracer = this.getSbbContext().getTracer("com.test");
            this.tracer.info("Received event TCKResourceEventX");
            this.doTest1113032Test();
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResultToTCK(String testName, boolean result, int failedAssertionID, String message) throws Exception {
        HashMap<String, Object> sbbData = new HashMap<String, Object>();
        sbbData.put("testname", testName);
        sbbData.put("result", result ? "pass" : "fail");
        sbbData.put("message", message);
        sbbData.put("id", new Integer(failedAssertionID));
        TCKSbbUtils.getResourceInterface().sendSbbMessage(sbbData);
    }

    private void doTest1113032Test() throws Exception {
        ProfileFacility facility = this.getProfileFacility();
        ProfileTable profileTable = null;
        try {
            profileTable = facility.getProfileTable(PROFILE_TABLE_NAME);
            if (profileTable == null) {
                this.sendResultToTCK("Test1113032Test", false, 1113032, "Invalid profiletable returned from ProfileFacility.getProfileTable()");
                return;
            }
            this.tracer.info("got expected ProfileTable", null);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
        try {
            Test1113032ProfileTable testProfileTable = (Test1113032ProfileTable)facility.getProfileTable(PROFILE_TABLE_NAME);
            this.tracer.info("got expected returned object which was casted to the profile table interface dined by the Profile Specification", null);
        }
        catch (UnrecognizedProfileTableNameException uptne) {
            this.tracer.info("got unexpected UnrecognizedProfileTableNameException", null);
            TCKSbbUtils.handleException((Exception)((Object)uptne));
        }
        catch (ClassCastException cce) {
            this.tracer.info("profile table Test1113032ProfileTable is not of expected profile specification: " + cce, null);
            this.sendResultToTCK("Test1113032Test", false, 1113033, "profile table Test1113032ProfileTable is not of expected profile specification: " + cce);
            return;
        }
        boolean passedA = false;
        try {
            profileTable = facility.getProfileTable("foo");
        }
        catch (UnrecognizedProfileTableNameException e) {
            this.tracer.info("got expected UnrecognizedProfileTableNameException", null);
            passedA = true;
        }
        if (!passedA) {
            this.sendResultToTCK("Test1113032Test", false, 1113036, "ProfileFacility.getProfileTable(InvalidProfileTableName) should have thrown UnrecognizedProfileTableNameException.");
            return;
        }
        boolean passedB = false;
        try {
            profileTable = facility.getProfileTable(null);
        }
        catch (NullPointerException e) {
            this.tracer.info("got expected NullPointerException", null);
            passedB = true;
        }
        if (!passedB) {
            this.sendResultToTCK("Test1113032Test", false, 1113037, "ProfileFacility.getProfileTable(null) should have thrown java.lang.NullPointerException.");
            return;
        }
        this.sendResultToTCK("Test1113032Test", true, 1113032, "ProfileFacility.getProfileTable tests passed");
    }

    private ProfileFacility getProfileFacility() throws Exception {
        this.tracer = this.getSbbContext().getTracer("com.test");
        ProfileFacility facility = null;
        try {
            facility = (ProfileFacility)new InitialContext().lookup(JNDI_PROFILEFACILITY_NAME);
        }
        catch (Exception e) {
            this.tracer.warning("got unexpected Exception: " + e, null);
        }
        return facility;
    }

    public abstract Test1113032ProfileCMP getProfileCMP(ProfileID var1) throws UnrecognizedProfileTableNameException, UnrecognizedProfileNameException;
}

