/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.facilities.profilefacility;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;

public class Test2087Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 2087;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private TCKActivityID activityID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils.getLog());
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        this.activityID = resource.createActivity("Test2087InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.activityID, null);
        return this.result.waitForResultOrFail(this.utils.getTestTimeout(), "Timeout waiting for test result.", 2087);
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
        ProfileProvisioningMBeanProxy profileProxy = new ProfileUtils(this.utils).getProfileProvisioningProxy();
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profileSpecID = (ProfileSpecificationID)components[i];
            this.utils.getLog().fine("Creating profile tables.");
            profileProxy.createProfileTable(profileSpecID, "Test2087ProfileTable");
            ObjectName profile = profileProxy.createProfile("Test2087ProfileTable", "Test2087Profile");
            ProfileMBeanProxy profProxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(profile);
            profProxy.commitProfile();
            this.utils.getLog().fine("Done");
        }
        this.utils.getLog().fine("Finished settting up test.");
    }

    public void tearDown() throws Exception {
        ProfileProvisioningMBeanProxy profileProxy = new ProfileUtils(this.utils).getProfileProvisioningProxy();
        try {
            profileProxy.removeProfile("Test2087ProfileTable", "Test2087Profile");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            profileProxy.removeProfileTable("Test2087ProfileTable");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            Test2087Test.this.utils.getLog().info("Received message from SBB.");
            if (passed.booleanValue()) {
                Test2087Test.this.result.setPassed();
            } else {
                Test2087Test.this.result.setFailed((Integer)map.get("ID"), msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test2087Test.this.utils.getLog().warning("Received exception from SBB");
            Test2087Test.this.utils.getLog().warning(e);
            Test2087Test.this.result.setError(e);
        }
    }
}

