/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.facilities.TimerFacility;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.RolledBackContext;
import javax.slee.facilities.Level;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;

public abstract class Test3546Sbb
extends BaseTCKSbb {
    private static final String JNDI_TIMERFACILITY_NAME = "java:comp/env/slee/facilities/timer";
    private static final long TIMEOUT = 500L;
    private static final long PERIOD = 1500L;

    public void sbbRolledBack(RolledBackContext context) {
    }

    public void onTCKResourceEventX1(TCKResourceEventX ev, ActivityContextInterface aci) {
        long currentTime = System.currentTimeMillis();
        try {
            TimerOptions options = new TimerOptions();
            options.setTimeout(500L);
            options.setPreserveMissed(TimerPreserveMissed.ALL);
            TimerFacility facility = (TimerFacility)new InitialContext().lookup(JNDI_TIMERFACILITY_NAME);
            this.setTimerID(facility.setTimer(aci, null, currentTime, 1500L, 3, options));
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.setCount(this.getCount() + 1);
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.FINE, "In timer event repetition " + this.getCount(), null);
            long scheduledTime = event.getScheduledTime();
            switch (this.getCount()) {
                case 1: {
                    this.setLastTime(scheduledTime);
                    return;
                }
                case 2: {
                    if (this.getLastTime() != scheduledTime - 1500L) {
                        map.put("Result", new Boolean(false));
                        map.put("Message", "Repeat timer incorrectly scheduled.");
                        TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
                        return;
                    }
                    this.setLastTime(scheduledTime);
                    return;
                }
                case 3: {
                    if (this.getLastTime() != scheduledTime - 1500L) {
                        map.put("Result", new Boolean(false));
                        map.put("Message", "Repeat timer incorrectly scheduled.");
                        TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
                        return;
                    }
                    if (event.getRemainingRepetitions() != 0) {
                        map.put("Result", new Boolean(false));
                        map.put("Message", "Repeating timer has remaining repetitions when it should have none.");
                        TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
                        return;
                    }
                    map.put("Result", new Boolean(true));
                    map.put("Message", "Ok");
                    TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
                    return;
                }
            }
            map.put("Result", new Boolean(false));
            map.put("Message", "EventSeen counter in unexpected state");
            TCKSbbUtils.getResourceInterface().sendSbbMessage(map);
            return;
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
            return;
        }
    }

    public abstract void setTimerID(TimerID var1);

    public abstract TimerID getTimerID();

    public abstract void setCount(int var1);

    public abstract int getCount();

    public abstract void setLastTime(long var1);

    public abstract long getLastTime();
}

