/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.facilities.Tracer;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.TraceMBeanProxyImpl;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;
import javax.slee.management.TraceNotification;

public class Test1113189Test
extends AbstractSleeTCKTest {
    private NotificationListener listener;
    private FutureResult result;
    private DeployableUnitID duID;
    private String testName;
    private SbbID sbbID;
    private ServiceID serviceID;
    private ObjectName traceMBeanName;
    private TraceMBeanProxy tracembean;
    private int receivedTraceNotifications;
    private int expectedTraceNotifications;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        if (this.getTestName().equals("SEVERE")) {
            this.expectedTraceNotifications = 2;
            this.receivedTraceNotifications = 0;
            this.doTest1113189Test(TraceLevel.WARNING);
        } else if (this.getTestName().equals("WARNING")) {
            this.expectedTraceNotifications = 4;
            this.receivedTraceNotifications = 0;
            this.doTest1113189Test(TraceLevel.INFO);
        } else if (this.getTestName().equals("INFO")) {
            this.expectedTraceNotifications = 6;
            this.receivedTraceNotifications = 0;
            this.doTest1113189Test(TraceLevel.CONFIG);
        } else if (this.getTestName().equals("CONFIG")) {
            this.expectedTraceNotifications = 8;
            this.receivedTraceNotifications = 0;
            this.doTest1113189Test(TraceLevel.FINE);
        } else if (this.getTestName().equals("FINE")) {
            this.expectedTraceNotifications = 10;
            this.receivedTraceNotifications = 0;
            this.doTest1113189Test(TraceLevel.FINER);
        } else if (this.getTestName().equals("FINER")) {
            this.expectedTraceNotifications = 12;
            this.receivedTraceNotifications = 0;
            this.doTest1113189Test(TraceLevel.FINEST);
        } else if (this.getTestName().equals("FINEST")) {
            this.expectedTraceNotifications = 14;
            this.receivedTraceNotifications = 0;
            this.doTest1113189Test(TraceLevel.FINEST);
        }
        Test1113189Test test1113189Test = this;
        synchronized (test1113189Test) {
            this.wait(this.utils().getTestTimeout());
        }
        if (this.expectedTraceNotifications == this.receivedTraceNotifications) {
            result.setPassed();
        } else {
            result.setFailed(1113189, "Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + this.expectedTraceNotifications + ", received " + this.receivedTraceNotifications + ")");
        }
    }

    public void doTest1113189Test(TraceLevel traceLevel) throws Exception {
        TraceMBeanProxy traceMBeanProxy = this.utils().getMBeanProxyFactory().createTraceMBeanProxy(this.utils().getSleeManagementMBeanProxy().getTraceMBean());
        if (this.sbbID == null) {
            throw new TCKTestErrorException("sbbID not found for serviceDUPath");
        }
        if (this.serviceID == null) {
            throw new TCKTestErrorException("serviceID not found for serviceDUPath");
        }
        SbbNotification sbbNotification = new SbbNotification(this.serviceID, this.sbbID);
        try {
            this.getLog().fine("Starting to test The trace level of a particular tracer is equal to the trace level assigned to it by an Administrator using a TraceMBean object.");
            traceMBeanProxy.setTraceLevel((NotificationSource)sbbNotification, "com.test", traceLevel);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setError("ERROR!", e);
        }
        String activityName = "Test1113189Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: " + this.testName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        SleeManagementMBeanProxy proxy = this.utils().getSleeManagementMBeanProxy();
        this.traceMBeanName = proxy.getTraceMBean();
        this.listener = new TraceNotificationListenerImpl();
        this.tracembean = new TraceMBeanProxyImpl(this.traceMBeanName, this.utils().getMBeanFacade());
        this.tracembean.addNotificationListener(this.listener, null, null);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ServiceID) {
                this.getLog().fine("Setting serviceID value.");
                this.serviceID = (ServiceID)components[i];
                continue;
            }
            if (!(components[i] instanceof SbbID)) continue;
            this.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        if (null != this.tracembean) {
            this.tracembean.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public String getTestName() {
        String returnTestName = "testName";
        this.testName = this.utils().getTestParams().getProperty(returnTestName);
        return this.testName;
    }

    public class TraceNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof TraceNotification) {
                TraceNotification traceNotification = (TraceNotification)notification;
                if (traceNotification.getType().equals("javax.slee.management.trace.sbb")) {
                    if (traceNotification.getMessage().equals("SEVERE:Test1113189TraceMessage")) {
                        Test1113189Test.this.receivedTraceNotifications = Test1113189Test.this.receivedTraceNotifications + 1;
                    } else if (traceNotification.getMessage().equals("WARNING:Test1113189TraceMessage")) {
                        Test1113189Test.this.receivedTraceNotifications = Test1113189Test.this.receivedTraceNotifications + 2;
                    } else if (traceNotification.getMessage().equals("INFO:Test1113189TraceMessage")) {
                        Test1113189Test.this.receivedTraceNotifications = Test1113189Test.this.receivedTraceNotifications + 3;
                    } else if (traceNotification.getMessage().equals("CONFIG:Test1113189TraceMessage")) {
                        Test1113189Test.this.receivedTraceNotifications = Test1113189Test.this.receivedTraceNotifications + 4;
                    } else if (traceNotification.getMessage().equals("FINE:Test1113189TraceMessage")) {
                        Test1113189Test.this.receivedTraceNotifications = Test1113189Test.this.receivedTraceNotifications + 5;
                    } else if (traceNotification.getMessage().equals("FINER:Test1113189TraceMessage")) {
                        Test1113189Test.this.receivedTraceNotifications = Test1113189Test.this.receivedTraceNotifications + 6;
                    } else if (traceNotification.getMessage().equals("FINEST:Test1113189TraceMessage")) {
                        Test1113189Test.this.receivedTraceNotifications = Test1113189Test.this.receivedTraceNotifications + 7;
                    }
                }
                return;
            }
        }
    }
}

