/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.DeployableUnitDescriptor;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import java.util.Date;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;

public class Test3742Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 3742;
    private SleeTCKTestUtils utils;
    private DeployableUnitID duID;
    private Date startDate;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        Date date = duDesc.getDeploymentDate();
        Date currentDate = new Date();
        if (date.getTime() < this.startDate.getTime()) {
            return TCKTestResult.failed(3742, "DeployableUnitDescriptor.getDate() returned Date object with time before the Deployable Unit was installed.");
        }
        if (date.getTime() > currentDate.getTime()) {
            return TCKTestResult.failed(3742, "DeployableUnitDescriptor.getDate() returned Date object with time after the current time.");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.startDate = new Date();
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }
}

