/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.ServiceDescriptor;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import javax.slee.ComponentID;
import javax.slee.management.ComponentDescriptor;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceDescriptor;

public class Test3940Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 3940;
    private SleeTCKTestUtils utils;
    private DeployableUnitID duID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        ComponentDescriptor[] descriptors = duProxy.getDescriptors(components);
        for (int i = 0; i < descriptors.length; ++i) {
            if (!(descriptors[i] instanceof ServiceDescriptor)) continue;
            ServiceDescriptor serviceDesc = (ServiceDescriptor)descriptors[i];
            try {
                if (serviceDesc.getRootSbb() == null) {
                    return TCKTestResult.failed(3940, "ServiceDescriptor.getRootSbb() didn't return the root SBB.");
                }
            }
            catch (Exception e) {
                return TCKTestResult.failed(3940, "ServiceDescriptor.getRootSbb() threw an exception.");
            }
            try {
                if (serviceDesc.getAddressProfileTable() != null) {
                    return TCKTestResult.failed(3943, "ServiceDescriptor.getAddressProfileTable() didn't return null.");
                }
            }
            catch (Exception e) {
                return TCKTestResult.failed(3943, "ServiceDescriptor.getAddressProfileTable() threw an exception.");
            }
            try {
                if (serviceDesc.getResourceInfoProfileTable() != null) {
                    return TCKTestResult.failed(3945, "ServiceDescriptor.getResourceInfoProfileTable() didn't return null.");
                }
            }
            catch (Exception e) {
                return TCKTestResult.failed(3945, "ServiceDescriptor.getResourceInfoProfileTable() threw an exception.");
            }
            return TCKTestResult.passed();
        }
        return TCKTestResult.error("Failed to find the ServiceDescriptor for the installed root SBB.");
    }

    public void setUp() throws Exception {
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }
}

