/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.management.ServiceUsageMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanLookup;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceUsageMBeanProxy;
import javax.slee.InvalidArgumentException;
import javax.slee.SbbID;
import javax.slee.UnrecognizedSbbException;
import javax.slee.management.DeployableUnitID;
import javax.slee.usage.UnrecognizedUsageParameterSetNameException;

public class ServiceUsageMBeanExceptionsTest
extends AbstractSleeTCKTest {
    private static final String TEMPORARY_SERVICE_DU_PATH = "serviceDUPath-Temp";
    private static final String CREATED_PARAMETER_SET = "CREATED_PARAMETER_SET";
    private UsageMBeanLookup usageMBeanLookupA;
    private UsageMBeanLookup usageMBeanLookupB;
    private ServiceUsageMBeanProxy serviceUsageMBeanProxy;
    private SbbID chosenSbb;
    private SbbID sbbInOtherService;
    private SbbID sbbNoUsage;
    private SbbID uninstalledSbb;

    public TCKTestResult run() throws Exception {
        this.testCreateUsageParameterSet();
        this.testRemoveUsageParameterSet();
        this.testGetUsageParameterSets();
        this.testGetSbbUsageMBean1Arg();
        this.testGetSbbUsageMBean2Args();
        this.testResetAllUsageParameters1Arg();
        return TCKTestResult.passed();
    }

    private void testCreateUsageParameterSet() throws Exception {
        try {
            this.serviceUsageMBeanProxy.createUsageParameterSet(this.chosenSbb, CREATED_PARAMETER_SET);
            this.getLog().info("Call to createUsageParameterSet() with valid arguments threw no Exception");
        }
        catch (UnrecognizedSbbException e) {
            throw new TCKTestErrorException("Call to createUsageParameterSet() with valid arguments threw an unexpected UnrecognizedSbbException:", (Exception)((Object)e));
        }
        try {
            this.serviceUsageMBeanProxy.createUsageParameterSet(this.uninstalledSbb, "invalid-attempt-1");
            throw new TCKTestFailureException(4559, "createUsageParameterSet() failed to throw the expected UnrecognizedSbbException when called with the id of an uninstalled SBB");
        }
        catch (UnrecognizedSbbException e) {
            this.getLog().info("Caught excpected UnrecognizedSbbException from call to createUsageParameterSet() with the id of an uninstalled SBB");
            try {
                this.serviceUsageMBeanProxy.createUsageParameterSet(this.sbbInOtherService, "invalid-attempt-2");
                throw new TCKTestFailureException(4559, "createUsageParameterSet() failed to throw the expected UnrecognizedSbbException when called with the id of an SBB not in the service represented by the ServiceUsageMBean");
            }
            catch (UnrecognizedSbbException e2) {
                this.getLog().info("Caught excpected UnrecognizedSbbException from call to createUsageParameterSet() with the id of an SBB not in the service represented by the ServiceUsageMBean");
                return;
            }
        }
    }

    private void testRemoveUsageParameterSet() throws Exception {
        try {
            this.serviceUsageMBeanProxy.removeUsageParameterSet(null, CREATED_PARAMETER_SET);
            throw new TCKTestFailureException(4567, "removeUsageParameterSet() failed to throw the expected NullPointerException when called with a null SBB ID");
        }
        catch (NullPointerException e) {
            this.getLog().info("Caught expected NullPointerException from call to removeUsageParameterSet when called with a null Sbb ID");
            try {
                this.serviceUsageMBeanProxy.removeUsageParameterSet(this.chosenSbb, null);
                throw new TCKTestFailureException(4567, "removeUsageParameterSet() failed to throw the expected NullPointerException when called with a null parameter set name");
            }
            catch (NullPointerException e2) {
                this.getLog().info("Caught expected NullPointerException from call to removeUsageParameterSet when called with a null parameter set name");
                try {
                    this.serviceUsageMBeanProxy.removeUsageParameterSet(null, null);
                    throw new TCKTestFailureException(4567, "removeUsageParameterSet() failed to throw the expected NullPointerException when called with a null SBB ID and parameter set name");
                }
                catch (NullPointerException e3) {
                    this.getLog().info("Caught expected NullPointerException from call to removeUsageParameterSet when called with a null SBB ID and parameter set name");
                    try {
                        this.serviceUsageMBeanProxy.removeUsageParameterSet(this.uninstalledSbb, CREATED_PARAMETER_SET);
                        throw new TCKTestFailureException(4568, "removeUsageParameterSet() failed to throw the expected UnrecognizedSbbException when called with the id of an uninstalled SBB");
                    }
                    catch (UnrecognizedSbbException e4) {
                        this.getLog().info("Caught expected UnrecognizedSbbException from call to removeUsageParameterSet when called with the id of an uninstalled SBB");
                        try {
                            this.serviceUsageMBeanProxy.removeUsageParameterSet(this.sbbInOtherService, CREATED_PARAMETER_SET);
                            throw new TCKTestFailureException(4568, "removeUsageParameterSet() failed to throw the expected UnrecognizedSbbException when called with the id of an SBB not in the service represented by the ServiceUsageMBean");
                        }
                        catch (UnrecognizedSbbException e5) {
                            this.getLog().info("Caught expected UnrecognizedSbbException from call to removeUsageParameterSet when called with the id of an SBB not in the service represented by the ServiceUsageMBean");
                            try {
                                this.serviceUsageMBeanProxy.removeUsageParameterSet(this.sbbNoUsage, CREATED_PARAMETER_SET);
                                throw new TCKTestFailureException(4569, "removeUsageParameterSet() failed to throw the expected InvalidArgumentException when called with the id of an SBB in the service represented by the ServiceUsageMBean, with no usage parameters interface");
                            }
                            catch (InvalidArgumentException e6) {
                                this.getLog().info("Caught expected InvalidArgumentException from call to removeUsageParameterSet when called with the id of an SBB in the service represented by the ServiceUsageMBean, with no usage parameters interface");
                                try {
                                    this.serviceUsageMBeanProxy.removeUsageParameterSet(this.chosenSbb, "unused-parameter-set-name");
                                    throw new TCKTestFailureException(4570, "removeUsageParameterSet() failed to throw the expected UnrecognizedUsageParameterSetNameException when called with a name that does not identify a usage parameter set that has been created for the SBB");
                                }
                                catch (UnrecognizedUsageParameterSetNameException e7) {
                                    this.getLog().info("Caught expected UnrecognizedUsageParameterSetNameException from call to removeUsageParameterSet when called with a name that does not identify a usage parameter set that has been created for the SBB");
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void testGetUsageParameterSets() throws Exception {
        try {
            this.serviceUsageMBeanProxy.getUsageParameterSets(null);
            throw new TCKTestFailureException(4576, "getUsageParameterSets() failed to throw the expected NullPointerException when called with a null SBB ID");
        }
        catch (NullPointerException e) {
            this.getLog().info("Caught expected NullPointerException from call to getUsageParameterSets() when called with a null Sbb ID");
            try {
                this.serviceUsageMBeanProxy.getUsageParameterSets(this.sbbNoUsage);
                throw new TCKTestFailureException(4577, "getUsageParameterSets() failed to throw the expected InvalidArgumentException when called with the id of an SBB in the service represented by the ServiceUsageMBean, with no usage parameters interface");
            }
            catch (InvalidArgumentException e2) {
                this.getLog().info("Caught expected InvalidArgumentException from call to getUsageParameterSets when called with the id of an SBB in the service represented by the ServiceUsageMBean, with no usage parameters interface");
                try {
                    this.serviceUsageMBeanProxy.getUsageParameterSets(this.uninstalledSbb);
                    throw new TCKTestFailureException(4578, "getUsageParameterSets() failed to throw the expected UnrecognizedSbbException when called with the id of an uninstalled SBB");
                }
                catch (UnrecognizedSbbException e3) {
                    this.getLog().info("Caught expected UnrecognizedSbbException from call to getUsageParameterSets when called with the id of an uninstalled SBB");
                    try {
                        this.serviceUsageMBeanProxy.getUsageParameterSets(this.sbbInOtherService);
                        throw new TCKTestFailureException(4578, "getUsageParameterSets() failed to throw the expected UnrecognizedSbbException when called with the id of an SBB not in the service represented by the ServiceUsageMBean");
                    }
                    catch (UnrecognizedSbbException e4) {
                        this.getLog().info("Caught expected UnrecognizedSbbException from call to getUsageParameterSets when called with the id of an SBB not in the service represented by the ServiceUsageMBean");
                        return;
                    }
                }
            }
        }
    }

    private void testGetSbbUsageMBean1Arg() throws Exception {
        try {
            this.serviceUsageMBeanProxy.getSbbUsageMBean(null);
            throw new TCKTestFailureException(4584, "getSbbUsageMBean(SbbID) failed to throw the expected NullPointerException when called with a null SBB ID");
        }
        catch (NullPointerException e) {
            this.getLog().info("Caught expected NullPointerException from call to getSbbUsageMBean(SbbID) when called with a null Sbb ID");
            try {
                this.serviceUsageMBeanProxy.getSbbUsageMBean(this.sbbNoUsage);
                throw new TCKTestFailureException(4651, "getSbbUsageMBean(SbbID) failed to throw the expected InvalidArgumentException when called with the id of an SBB in the service represented by the ServiceUsageMBean, with no usage parameters interface");
            }
            catch (InvalidArgumentException e2) {
                this.getLog().info("Caught expected InvalidArgumentException from call to getSbbUsageMBean(SbbID) when called with the id of an SBB in the service represented by the ServiceUsageMBean, with no usage parameters interface");
                try {
                    this.serviceUsageMBeanProxy.getSbbUsageMBean(this.uninstalledSbb);
                    throw new TCKTestFailureException(4585, "getSbbUsageMBean(SbbID) failed to throw the expected UnrecognizedSbbException when called with the id of an uninstalled SBB");
                }
                catch (UnrecognizedSbbException e3) {
                    this.getLog().info("Caught expected UnrecognizedSbbException from call to getSbbUsageMBean(SbbID) when called with the id of an uninstalled SBB");
                    try {
                        this.serviceUsageMBeanProxy.getSbbUsageMBean(this.sbbInOtherService);
                        throw new TCKTestFailureException(4585, "getSbbUsageMBean(SbbID) failed to throw the expected UnrecognizedSbbException when called with the id of an SBB not in the service represented by the ServiceUsageMBean");
                    }
                    catch (UnrecognizedSbbException e4) {
                        this.getLog().info("Caught expected UnrecognizedSbbException from call to getSbbUsageMBean(SbbID) when called with the id of an SBB not in the service represented by the ServiceUsageMBean");
                        return;
                    }
                }
            }
        }
    }

    private void testGetSbbUsageMBean2Args() throws Exception {
        try {
            this.serviceUsageMBeanProxy.getSbbUsageMBean(null, CREATED_PARAMETER_SET);
            throw new TCKTestFailureException(4591, "getSbbUsageMBean(SbbID,String) failed to throw the expected NullPointerException when called with a null SBB ID");
        }
        catch (NullPointerException e) {
            this.getLog().info("Caught expected NullPointerException from call to getSbbUsageMBean(SbbID,String) when called with a null Sbb ID");
            try {
                this.serviceUsageMBeanProxy.getSbbUsageMBean(this.chosenSbb, null);
                throw new TCKTestFailureException(4591, "getSbbUsageMBean(SbbID,String) failed to throw the expected NullPointerException when called with a null parameter set name");
            }
            catch (NullPointerException e2) {
                this.getLog().info("Caught expected NullPointerException from call to getSbbUsageMBean(SbbID,String) when called with a null parameter set name");
                try {
                    this.serviceUsageMBeanProxy.getSbbUsageMBean(null, null);
                    throw new TCKTestFailureException(4591, "getSbbUsageMBean(SbbID,String) failed to throw the expected NullPointerException when called with a null SBB id and parameter set name");
                }
                catch (NullPointerException e3) {
                    this.getLog().info("Caught expected NullPointerException from call to getSbbUsageMBean(SbbID,String) when called with a null SBB id and parameter set name");
                    try {
                        this.serviceUsageMBeanProxy.getSbbUsageMBean(this.sbbNoUsage, CREATED_PARAMETER_SET);
                        throw new TCKTestFailureException(4592, "getSbbUsageMBean(SbbID,String) failed to throw the expected InvalidArgumentException when called with the id of an SBB in the service represented by the ServiceUsageMBean, with no usage parameters interface");
                    }
                    catch (InvalidArgumentException e4) {
                        this.getLog().info("Caught expected InvalidArgumentException from call to getSbbUsageMBean(SbbID,String) when called with the id of an SBB in the service represented by the ServiceUsageMBean, with no usage parameters interface");
                        try {
                            this.serviceUsageMBeanProxy.getSbbUsageMBean(this.uninstalledSbb, CREATED_PARAMETER_SET);
                            throw new TCKTestFailureException(4654, "getSbbUsageMBean(SbbID,String) failed to throw the expected UnrecognizedSbbException when called with the id of an uninstalled SBB");
                        }
                        catch (UnrecognizedSbbException e5) {
                            this.getLog().info("Caught expected UnrecognizedSbbException from call to getSbbUsageMBean(SbbID,String) when called with the id of an uninstalled SBB");
                            try {
                                this.serviceUsageMBeanProxy.getSbbUsageMBean(this.sbbInOtherService, CREATED_PARAMETER_SET);
                                throw new TCKTestFailureException(4654, "getSbbUsageMBean(SbbID,String) failed to throw the expected UnrecognizedSbbException when called with the id of an SBB not in the service represented by the ServiceUsageMBean");
                            }
                            catch (UnrecognizedSbbException e6) {
                                this.getLog().info("Caught expected UnrecognizedSbbException from call to getSbbUsageMBean(SbbID,String) when called with the id of an SBB not in the service represented by the ServiceUsageMBean");
                                try {
                                    this.serviceUsageMBeanProxy.getSbbUsageMBean(this.chosenSbb, "unused-parameter-set-name");
                                    throw new TCKTestFailureException(4655, "getSbbUsageMBean(SbbID,String) failed to throw the expected UnrecognizedUsageParameterSetNameException when called with a name that does not identify a usage parameter set that has been created for the SBB");
                                }
                                catch (UnrecognizedUsageParameterSetNameException e7) {
                                    this.getLog().info("Caught expected UnrecognizedUsageParameterSetNameException from call to getSbbUsageMBean(SbbID,String) when called with a name that does not identify a usage parameter set that has been created for the SBB");
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void testResetAllUsageParameters1Arg() throws Exception {
        try {
            this.serviceUsageMBeanProxy.resetAllUsageParameters(null);
            throw new TCKTestFailureException(4622, "resetAllUsageParameters(SbbID) failed to throw the expected NullPointerException when called with a null SBB ID");
        }
        catch (NullPointerException e) {
            this.getLog().info("Caught expected NullPointerException from call to resetAllUsageParameters(SbbID) when called with a null Sbb ID");
            try {
                this.serviceUsageMBeanProxy.resetAllUsageParameters(this.sbbNoUsage);
                throw new TCKTestFailureException(4624, "resetAllUsageParameters(SbbID) failed to throw the expected InvalidArgumentException when called with the id of an SBB in the service represented by the ServiceUsageMBean, with no usage parameters interface");
            }
            catch (InvalidArgumentException e2) {
                this.getLog().info("Caught expected InvalidArgumentException from call to resetAllUsageParameters(SbbID) when called with the id of an SBB in the service represented by the ServiceUsageMBean, with no usage parameters interface");
                try {
                    this.serviceUsageMBeanProxy.resetAllUsageParameters(this.uninstalledSbb);
                    throw new TCKTestFailureException(4623, "resetAllUsageParameters(SbbID) failed to throw the expected UnrecognizedSbbException when called with the id of an uninstalled SBB");
                }
                catch (UnrecognizedSbbException e3) {
                    this.getLog().info("Caught expected UnrecognizedSbbException from call to resetAllUsageParameters(SbbID) when called with the id of an uninstalled SBB");
                    try {
                        this.serviceUsageMBeanProxy.resetAllUsageParameters(this.sbbInOtherService);
                        throw new TCKTestFailureException(4623, "resetAllUsageParameters(SbbID) failed to throw the expected UnrecognizedSbbException when called with the id of an SBB not in the service represented by the ServiceUsageMBean");
                    }
                    catch (UnrecognizedSbbException e4) {
                        this.getLog().info("Caught expected UnrecognizedSbbException from call to resetAllUsageParameters(SbbID) when called with the id of an SBB not in the service represented by the ServiceUsageMBean");
                        return;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUp() throws Exception {
        ComponentIDLookup idLookup;
        block6: {
            super.setUp();
            DeployableUnitID duID = null;
            idLookup = new ComponentIDLookup(this.utils());
            try {
                String relativePath = this.utils().getTestParams().getProperty(TEMPORARY_SERVICE_DU_PATH);
                String fullURL = this.utils().getDeploymentUnitURL(relativePath);
                this.getLog().fine("Installing deployable unit " + fullURL);
                duID = this.utils().getDeploymentMBeanProxy().install(fullURL);
                this.uninstalledSbb = idLookup.lookupSbbID("GenericUsageSbb", "jain.slee.tck", null);
                if (duID == null) break block6;
            }
            catch (Throwable throwable) {
                if (duID == null) throw throwable;
                try {
                    this.utils().getDeploymentMBeanProxy().uninstall(duID);
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLog().warning(e);
                }
                throw throwable;
            }
            try {
                this.utils().getDeploymentMBeanProxy().uninstall(duID);
            }
            catch (Exception e) {
                this.getLog().warning(e);
            }
        }
        this.usageMBeanLookupA = new UsageMBeanLookup("ServiceUsageMBeanExceptionsTestServiceA", "ServiceUsageMBeanExceptionsChildSbbA", this.utils());
        this.usageMBeanLookupB = new UsageMBeanLookup("ServiceUsageMBeanExceptionsTestServiceB", "ServiceUsageMBeanExceptionsChildSbbB", this.utils());
        this.serviceUsageMBeanProxy = this.usageMBeanLookupA.getServiceUsageMBeanProxy();
        this.chosenSbb = this.usageMBeanLookupA.getSbbID();
        this.sbbInOtherService = this.usageMBeanLookupB.getSbbID();
        this.sbbNoUsage = idLookup.lookupSbbID("ServiceUsageMBeanExceptionsParentSbbA", "jain.slee.tck", null);
    }

    public void tearDown() throws Exception {
        if (this.usageMBeanLookupA != null) {
            this.usageMBeanLookupA.closeAllMBeans();
        }
        if (this.usageMBeanLookupB != null) {
            this.usageMBeanLookupB.closeAllMBeans();
        }
        super.tearDown();
    }
}

