/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.profile.ProfileContext;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.profileutils.BaseMessageAdapter;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testutils.FutureAssertionsResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.TraceMBeanProxyImpl;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.slee.management.ProfileTableNotification;
import javax.slee.management.TraceNotification;
import javax.slee.profile.ProfileSpecificationID;

public class Test1110310Test
extends AbstractSleeTCKTest {
    private static final String DU_PATH_PARAM = "DUPath";
    private static final String SPEC_NAME = "Test1110310Profile";
    private static final String SPEC_VERSION = "1.0";
    private static final int TEST_ID = 1110310;
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;
    private NotificationListener notificationListener;
    private TraceMBeanProxy tracembeanProxy;
    private RMIObjectChannel in;
    private TCKTestResult exResult;
    private FutureAssertionsResult futureResult;

    public TCKTestResult run() throws Exception {
        this.exResult = null;
        this.futureResult = new FutureAssertionsResult(new int[]{1110310, 1110311, 1110315, 1110319, 1110324, 1110327, 1110328, 1110334}, this.getLog());
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, "Test1110310ProfileTable");
        this.getLog().fine("Added profile table Test1110310ProfileTable based on profile spec Test1110310Profile");
        TCKTestResult res = this.futureResult.waitForResult(this.utils().getTestTimeout());
        if (!res.isPassed()) {
            return res;
        }
        ObjectName profile = this.profileProvisioning.createProfile("Test1110310ProfileTable", SPEC_NAME);
        ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.getLog().fine("Created profile Test1110310Profile for profile table Test1110310ProfileTable");
        profileProxy.commitProfile();
        profileProxy.closeProfile();
        this.getLog().fine("Call management method on profile, this should also trigger the Tracer tests.");
        this.futureResult = new FutureAssertionsResult(new int[]{1110339, 1110340}, this.getLog());
        profile = this.profileProvisioning.getProfile("Test1110310ProfileTable", SPEC_NAME);
        this.utils().getMBeanFacade().invoke(profile, "manage", new Object[0], new String[0]);
        res = this.futureResult.waitForResult(this.utils().getTestTimeout());
        if (!res.isPassed()) {
            return res;
        }
        this.getLog().fine("Call management method on default profile.");
        this.futureResult = new FutureAssertionsResult(new int[]{1110756}, this.getLog());
        ObjectName defaultProfile = this.profileProvisioning.getDefaultProfile("Test1110310ProfileTable");
        this.utils().getMBeanFacade().invoke(defaultProfile, "invokeOnDefaultProfile", new Object[0], new String[0]);
        res = this.futureResult.waitForResult(this.utils().getTestTimeout());
        if (!res.isPassed()) {
            return res;
        }
        this.getLog().fine("Remove profile Test1110310Profile");
        this.profileProvisioning.removeProfile("Test1110310ProfileTable", SPEC_NAME);
        Thread.sleep(2000L);
        if (this.exResult != null) {
            return this.exResult;
        }
        return TCKTestResult.passed();
    }

    public void setPassed(int assertionID, String msg) {
        this.getLog().fine(assertionID + ": " + msg);
        if (this.futureResult != null && !this.futureResult.isSet()) {
            this.futureResult.setPassed(assertionID);
        }
    }

    public void setFailed(int assertionID, String msg, Exception e) {
        if (e == null) {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(assertionID, msg);
            }
            this.setIfEmpty(TCKTestResult.failed(assertionID, msg));
        } else {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            this.getLog().fine(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(new TCKTestFailureException(assertionID, msg, e));
            }
            this.setIfEmpty(TCKTestResult.failed(new TCKTestFailureException(assertionID, msg, e)));
        }
    }

    public void setError(String msg, Exception e) {
        if (e == null) {
            this.getLog().warning(msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg);
            }
            this.setIfEmpty(TCKTestResult.error(msg));
        } else {
            this.getLog().warning(msg);
            this.getLog().warning(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg, e);
            }
            this.setIfEmpty(TCKTestResult.error(msg, e));
        }
    }

    public void setUp() throws Exception {
        this.setupService(DU_PATH_PARAM);
        this.in = this.utils().getRMIObjectChannel();
        this.in.setMessageHandler(new BaseMessageAdapter(this.getLog()){

            public void onSetPassed(int assertionID, String msg) {
                Test1110310Test.this.setPassed(assertionID, msg);
            }

            public void onSetFailed(int assertionID, String msg, Exception e) {
                Test1110310Test.this.setFailed(assertionID, msg, e);
            }

            public void onLogCall(String msg) {
                Test1110310Test.this.getLog().fine(msg);
            }

            public void onSetError(String msg, Exception e) {
                Test1110310Test.this.setError(msg, e);
            }
        });
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        SleeManagementMBeanProxy sleeManagementProxy = this.utils().getSleeManagementMBeanProxy();
        ObjectName traceMBeanName = sleeManagementProxy.getTraceMBean();
        this.notificationListener = new TraceNotificationListenerImpl();
        this.tracembeanProxy = new TraceMBeanProxyImpl(traceMBeanName, this.utils().getMBeanFacade());
        this.tracembeanProxy.addNotificationListener(this.notificationListener, null, null);
    }

    public void tearDown() throws Exception {
        this.in.clearQueue();
        if (null != this.tracembeanProxy) {
            this.tracembeanProxy.removeNotificationListener(this.notificationListener);
        }
        try {
            this.profileUtils.removeProfileTable("Test1110310ProfileTable");
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private void setIfEmpty(TCKTestResult exResult) {
        if (this.exResult == null) {
            this.exResult = exResult;
        }
    }

    public class TraceNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof TraceNotification) {
                TraceNotification traceNotification = (TraceNotification)notification;
                if (notification.getMessage().equals("TraceSuccessMsg")) {
                    BaseMessageSender msgSender;
                    try {
                        RMIObjectChannel out = TCKRAUtils.lookupRMIObjectChannel();
                        msgSender = new BaseMessageSender(out, new StdErrLog());
                    }
                    catch (Exception e) {
                        Test1110310Test.this.getLog().warning("An error occured creating an RMIObjectChannel: ");
                        Test1110310Test.this.getLog().warning(e);
                        Test1110310Test.this.setIfEmpty(TCKTestResult.error("An error occured creating an RMIObjectChannel: ", e));
                        return;
                    }
                    if (traceNotification.getNotificationSource() instanceof ProfileTableNotification) {
                        msgSender.sendSuccess(1110339, "Notification source is of type javax.slee.management.ProfileTableNotification as expected");
                    } else {
                        msgSender.sendFailure(1110339, "Notification source is of wrong type: " + traceNotification.getNotificationSource().getClass().getName() + " Expected javax.slee.management.ProfileTableNotification");
                    }
                    if (traceNotification.getType().equals("javax.slee.management.trace.profiletable")) {
                        msgSender.sendSuccess(1110340, "Notification type is ProfileTableNotification.TRACE_NOTIFICATION_TYPE as expected");
                    } else {
                        msgSender.sendSuccess(1110340, "Notification type is wrong " + traceNotification.getType() + " Expected ProfileTableNotification.TRACE_NOTIFICATION_TYPE");
                    }
                }
                return;
            }
        }
    }
}

