/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.javax.slee.profile.ProfileContext;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.profileutils.BaseMessageAdapter;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.FutureAssertionsResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class Test1110346Test
extends AbstractSleeTCKTest {
    private static final String SBB_EVENT_DU_PATH = "sbbEventDUPath";
    private static final String DU_PATH_PARAM = "DUPath";
    private static final String SPEC_NAME = "Test1110346Profile";
    private static final String SPEC_VERSION = "1.0";
    private static final int TEST_ID = 1110346;
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;
    private RMIObjectChannel in;
    private TCKTestResult exResult;
    private FutureAssertionsResult futureResult;

    public TCKTestResult run() throws Exception {
        this.exResult = null;
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, "Test1110346ProfileTable");
        this.getLog().fine("Added profile table Test1110346ProfileTable based on profile spec Test1110346Profile");
        ObjectName profile = this.profileProvisioning.createProfile("Test1110346ProfileTable", SPEC_NAME);
        ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.getLog().fine("Created profile Test1110346Profile for profile table Test1110346ProfileTable");
        profileProxy.commitProfile();
        profileProxy.closeProfile();
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(this.getClass().getName());
        this.futureResult = new FutureAssertionsResult(new int[]{1110346}, this.getLog());
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", new Integer(3), activityID, null);
        this.futureResult.waitForResult(this.utils().getTestTimeout());
        this.getLog().fine("Cause Sbb to call a business method...");
        this.futureResult = new FutureAssertionsResult(new int[]{1110346}, this.getLog());
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", new Integer(1), activityID, null);
        TCKTestResult res = this.futureResult.waitForResult(this.utils().getTestTimeout());
        if (!res.isPassed()) {
            return res;
        }
        this.futureResult = new FutureAssertionsResult(new int[]{1110346}, this.getLog());
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", new Integer(4), activityID, null);
        this.futureResult.waitForResult(this.utils().getTestTimeout());
        this.getLog().fine("Cause Sbb to mark a TXN context for rollback and call a business method to check...");
        this.futureResult = new FutureAssertionsResult(new int[]{1110346}, this.getLog());
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", new Integer(2), activityID, null);
        res = this.futureResult.waitForResult(this.utils().getTestTimeout());
        if (!res.isPassed()) {
            return res;
        }
        if (this.exResult != null) {
            return this.exResult;
        }
        return TCKTestResult.passed();
    }

    public void setPassed(int assertionID, String msg) {
        this.getLog().fine(assertionID + ": " + msg);
        if (this.futureResult != null && !this.futureResult.isSet()) {
            this.futureResult.setPassed(assertionID);
        }
    }

    public void setFailed(int assertionID, String msg, Exception e) {
        if (e == null) {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(assertionID, msg);
            }
            this.setIfEmpty(TCKTestResult.failed(assertionID, msg));
        } else {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            this.getLog().fine(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(new TCKTestFailureException(assertionID, msg, e));
            }
            this.setIfEmpty(TCKTestResult.failed(new TCKTestFailureException(assertionID, msg, e)));
        }
    }

    public void setError(String msg, Exception e) {
        if (e == null) {
            this.getLog().warning(msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg);
            }
            this.setIfEmpty(TCKTestResult.error(msg));
        } else {
            this.getLog().warning(msg);
            this.getLog().warning(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg, e);
            }
            this.setIfEmpty(TCKTestResult.error(msg, e));
        }
    }

    public void setUp() throws Exception {
        this.setupService(SBB_EVENT_DU_PATH);
        this.setupService(DU_PATH_PARAM);
        this.in = this.utils().getRMIObjectChannel();
        this.in.setMessageHandler(new BaseMessageAdapter(this.getLog()){

            public void onSetPassed(int assertionID, String msg) {
                Test1110346Test.this.setPassed(assertionID, msg);
            }

            public void onSetFailed(int assertionID, String msg, Exception e) {
                Test1110346Test.this.setFailed(assertionID, msg, e);
            }

            public void onLogCall(String msg) {
                Test1110346Test.this.getLog().fine(msg);
            }

            public void onSetError(String msg, Exception e) {
                Test1110346Test.this.setError(msg, e);
            }
        });
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        this.in.clearQueue();
        try {
            this.profileUtils.removeProfileTable("Test1110346ProfileTable");
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private void setIfEmpty(TCKTestResult exResult) {
        if (this.exResult == null) {
            this.exResult = exResult;
        }
    }
}

