/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.libraries;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import java.rmi.RemoteException;
import javax.slee.ServiceID;
import javax.slee.management.DependencyException;
import javax.slee.management.DeployableUnitID;

public class Test1116001Test
extends AbstractSleeTCKTest {
    private static final int TEST_ID = 1116001;
    private TCKResourceListenerImpl resourceListener;
    private FutureResult result;
    private DeployableUnitID libraryDuID;
    private DeployableUnitID serviceDuID;
    private DeploymentMBeanProxy deploymentMBean;
    private String libraryDUPath;
    private String serviceDUPath;
    private ServiceID serviceID;

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils().getLog());
        this.utils().getLog().fine("Create Activity and fire starting event");
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(this.getClass().getName());
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activityID, null);
        TCKTestResult tckresult = this.result.waitForResult(5000L);
        resource.clearActivities();
        try {
            this.utils().getLog().fine("1114409 - uninstall library DU");
            this.deploymentMBean.uninstall(this.libraryDuID);
            tckresult = TCKTestResult.failed(1114409, "Library could be deployed when there were dependencies on it.");
        }
        catch (DependencyException de) {
            this.utils().getLog().info("Check for assertion 1114409 OK");
            tckresult = TCKTestResult.passed();
        }
        catch (Exception e) {
            tckresult = TCKTestResult.failed(1114409, "Library deployment failed with exception other than DependencyException: " + e);
        }
        return tckresult;
    }

    public void setUp() throws Exception {
        this.utils().getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils().getResourceInterface().setResourceListener(this.resourceListener);
        this.deploymentMBean = this.utils().getDeploymentMBeanProxy();
        try {
            this.libraryDUPath = this.utils().getTestParams().getProperty("libraryDUPath");
            this.utils().getLog().fine("Installing library: " + this.utils().getDeploymentUnitURL(this.libraryDUPath));
            this.libraryDuID = this.deploymentMBean.install(this.utils().getDeploymentUnitURL(this.libraryDUPath));
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception raised trying to install library" + e);
            throw new TCKTestErrorException("Failed to Install Library DU");
        }
        this.serviceDUPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.serviceDuID = this.deploymentMBean.install(this.utils().getDeploymentUnitURL(this.serviceDUPath));
        this.serviceID = new ServiceID("Test1116001TestService", "jain.slee.tck", "1.1");
        this.utils().getServiceManagementMBeanProxy().activate(this.serviceID);
        this.utils().getLog().fine("Test set up complete");
    }

    public void tearDown() throws Exception {
        try {
            this.utils().getResourceInterface().clearActivities();
            this.utils().getResourceInterface().removeResourceListener();
            if (this.serviceDuID != null) {
                this.utils().deactivateService(this.serviceID);
                this.deploymentMBean.uninstall(this.serviceDuID);
            } else {
                this.getLog().fine("serviceDuID is null");
            }
            if (this.libraryDuID != null) {
                this.deploymentMBean.uninstall(this.libraryDuID);
            } else {
                this.getLog().fine("libraryDuID is null");
            }
            super.tearDown();
            this.utils().getLog().info("This test has finished.");
        }
        catch (Exception e) {
            this.utils().getLog().fine("Exception raised in tearDown()" + e);
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID activity) throws RemoteException {
            Test1116001Test.this.utils().getLog().info("Received message from SBB: " + message.getMessage());
            Test1116001Test.this.result.setPassed();
        }

        public void onException(Exception e) throws RemoteException {
            Test1116001Test.this.utils().getLog().warning("Received exception from SBB.");
            Test1116001Test.this.utils().getLog().warning(e);
            Test1116001Test.this.result.setError(e);
        }
    }
}

