/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.AlarmMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.jmx.AlarmMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.AlarmMBeanProxyImpl;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.facilities.AlarmLevel;
import javax.slee.management.Alarm;
import javax.slee.management.AlarmNotification;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;

public class Test1114148Test
extends AbstractSleeTCKTest {
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private NotificationListener listener;
    private DeployableUnitID duID;
    private AlarmMBeanProxy alarmMBeanProxy;
    private ObjectName alarmMBean;
    private String alarmMBeanName;
    private TCKTestResult result;
    private SbbID sbbID;
    private ServiceID serviceID;
    private SbbNotification sbbNotification;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCKTestResult run() throws Exception {
        if (this.sbbID == null) {
            throw new TCKTestErrorException("sbbID not found for serviceDUPath");
        }
        if (this.serviceID == null) {
            throw new TCKTestErrorException("serviceID not found for serviceDUPath");
        }
        String activityName = "Test1114148Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        Test1114148Test test1114148Test = this;
        synchronized (test1114148Test) {
            this.wait(this.utils().getTestTimeout());
        }
        return this.result;
    }

    public void setUp() throws Exception {
        this.getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        SleeManagementMBeanProxy proxy = this.utils().getSleeManagementMBeanProxy();
        this.alarmMBean = proxy.getAlarmMBean();
        this.alarmMBeanName = this.alarmMBean.toString();
        this.getLog().info("1114148: Object Name of an AlarmMBean is: " + this.alarmMBeanName);
        if (this.alarmMBeanName.equals("javax.slee.management:name=Alarm")) {
            this.logSuccessfulCheck(1114148);
        }
        this.listener = new AlarmNotificationListenerImpl();
        this.alarmMBeanProxy = new AlarmMBeanProxyImpl(this.alarmMBean, this.utils().getMBeanFacade());
        this.alarmMBeanProxy.addNotificationListener(this.listener, null, null);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ServiceID) {
                this.getLog().fine("Setting serviceID value.");
                this.serviceID = (ServiceID)components[i];
                continue;
            }
            if (!(components[i] instanceof SbbID)) continue;
            this.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        String[] listActiveAlarms = this.alarmMBeanProxy.getAlarms();
        if (this.alarmMBeanProxy.getAlarms().length > 0) {
            for (int i = 0; i < listActiveAlarms.length; ++i) {
                this.alarmMBeanProxy.clearAlarm(listActiveAlarms[i]);
            }
        }
        if (null != this.alarmMBeanProxy) {
            this.alarmMBeanProxy.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    private TCKTestResult doAlarmMBeanCheck(Notification notification) {
        if (notification instanceof AlarmNotification) {
            try {
                AlarmNotification alarmNotification = (AlarmNotification)notification;
                String alarmID = alarmNotification.getAlarmID();
                SbbNotification notificationSource = (SbbNotification)alarmNotification.getNotificationSource();
                String alarmType = alarmNotification.getAlarmType();
                String instanceID = alarmNotification.getInstanceID();
                AlarmLevel alarmLevel = alarmNotification.getAlarmLevel();
                String message = alarmNotification.getMessage();
                Throwable cause = alarmNotification.getCause();
                long timestamp = alarmNotification.getTimeStamp();
                this.getLog().fine("Creating Alarm from notification...");
                Alarm alarm = new Alarm(alarmID, (NotificationSource)notificationSource, alarmType, instanceID, alarmLevel, message, cause, timestamp);
                if (alarm == null) {
                    return TCKTestResult.failed(1114166, "The Alarm object returned null");
                }
                this.logSuccessfulCheck(1114166);
                if (alarm.getAlarmID() != alarmID) {
                    return TCKTestResult.failed(1114418, "Alarm.getAlarmID() returned incorrect ID.");
                }
                this.logSuccessfulCheck(1114418);
                NotificationSource newAlarmNotification = alarm.getNotificationSource();
                SbbNotification newNotificationSource = (SbbNotification)newAlarmNotification;
                if (!newNotificationSource.equals((Object)notificationSource)) {
                    this.getLog().warning("Error in getNotificationSource: obtained " + newAlarmNotification);
                    return TCKTestResult.failed(0x110133, "Alarm.getNotificationSource() returned incorrect notification source.");
                }
                this.logSuccessfulCheck(0x110133);
                if (alarm.getAlarmType() != alarmType) {
                    return TCKTestResult.failed(1114420, "Alarm.getAlarmType() returned incorrect Alarm Type.");
                }
                this.logSuccessfulCheck(1114420);
                if (alarm.getInstanceID() != instanceID) {
                    return TCKTestResult.failed(1114421, "Alarm.getInstanceID() returned incorrect Instance ID.");
                }
                this.logSuccessfulCheck(1114421);
                if (alarm.getAlarmLevel() != alarmLevel) {
                    return TCKTestResult.failed(1114167, "Alarm.getAlarmLevel() returned incorrect Alarm Level.");
                }
                this.logSuccessfulCheck(1114167);
                if (alarm.getMessage() != message) {
                    return TCKTestResult.failed(1114170, "Alarm.getMessage() returned incorrect message.");
                }
                this.logSuccessfulCheck(1114170);
                if (alarm.getCause() != cause) {
                    return TCKTestResult.failed(1114169, "Alarm.getCause() returned incorrect cause.");
                }
                this.logSuccessfulCheck(1114169);
                if (alarm.getTimestamp() != timestamp) {
                    return TCKTestResult.failed(1114175, "Alarm.getTimestamp() returned incorrect timestamp.");
                }
                this.logSuccessfulCheck(1114175);
                Alarm alarm2 = alarm;
                String ALARM_MESSAGE = "Test1114148DummyAlarmMessage";
                String ALARM_INSTANCEID = "Test1114148DummylarmInstanceID";
                String dummyalarmID = "Test1114148AlarmId";
                String dummyalarmType = "TestAlarm";
                String dummyinstanceID = "Test1114148AlarmInstanceID";
                AlarmLevel dummyalarmLevel = AlarmLevel.MAJOR;
                String dummymessage = "Test1114148Alarm";
                Throwable dummycause = null;
                long dummytimestamp = 1042725L;
                Alarm dummyAlarm = new Alarm(dummyalarmID, (NotificationSource)notificationSource, dummyalarmType, dummyinstanceID, dummyalarmLevel, dummymessage, dummycause, dummytimestamp);
                String dummyAlarmID = dummyAlarm.getAlarmID();
                this.getLog().fine("Created Dummy Alarm: " + dummyAlarmID);
                if (alarm.equals((Object)alarm2)) {
                    if (alarm.equals((Object)dummyAlarm)) {
                        return TCKTestResult.failed(1114174, "Alarm.equals() returned incorrect comparisonon non-equals Alarm");
                    }
                } else {
                    return TCKTestResult.failed(1114174, "Alarm.equals() returned incorrect comparison on equals Alarm.");
                }
                this.logSuccessfulCheck(1114174);
                try {
                    int hashCode = alarm.hashCode();
                    this.logSuccessfulCheck(1114168);
                }
                catch (Exception e) {
                    this.getLog().warning(e);
                    return TCKTestResult.failed(1114168, "hashCode() raised exception: ");
                }
                try {
                    String alarmString = alarm.toString();
                    this.logSuccessfulCheck(1114171);
                }
                catch (Exception e) {
                    this.getLog().warning(e);
                    return TCKTestResult.failed(1114171, "hashCode() raised exception: ");
                }
                return TCKTestResult.passed();
            }
            catch (Exception e) {
                this.getLog().warning(e);
                return TCKTestResult.error("ERROR creating Alarm", e);
            }
        }
        return TCKTestResult.error("ERROR creating Alarm");
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }

    public class AlarmNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof AlarmNotification) {
                Test1114148Test.this.getLog().fine("Received Alarm Notification: " + notification);
                Test1114148Test.this.result = Test1114148Test.this.doAlarmMBeanCheck(notification);
            }
        }
    }
}

