/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.NotificationSource;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.TraceMBeanProxyImpl;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;
import javax.slee.management.TraceNotification;

public class Test1114380Test
extends AbstractSleeTCKTest {
    private TCKResourceListener resourceListener;
    private NotificationListener listener;
    private FutureResult result;
    private DeployableUnitID duID;
    private String testName = "Test1114380";
    private int assertionID = 0x11010C;
    private SbbID sbbID;
    private ServiceID serviceID;
    private ObjectName traceMBeanName;
    private TraceMBeanProxy tracembean;
    private int receivedTraceNotifications = 0;
    private int expectedTraceNotifications;
    private boolean passed = false;
    private SbbNotification sbbNotification;
    private TraceMBeanProxy traceMBeanProxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        this.expectedTraceNotifications = 1;
        this.doTest1114380Test(TraceLevel.INFO);
        Test1114380Test test1114380Test = this;
        synchronized (test1114380Test) {
            this.wait(this.utils().getTestTimeout());
        }
        if (this.passed && this.expectedTraceNotifications == this.receivedTraceNotifications) {
            result.setPassed();
        } else {
            result.setFailed(this.assertionID, "Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + this.expectedTraceNotifications + ", received " + this.receivedTraceNotifications + ")");
        }
    }

    public void doTest1114380Test(TraceLevel traceLevel) throws Exception {
        this.traceMBeanProxy = this.utils().getTraceMBeanProxy();
        if (this.sbbID == null) {
            throw new TCKTestErrorException("sbbID not found for serviceDUPath");
        }
        if (this.serviceID == null) {
            throw new TCKTestErrorException("serviceID not found for serviceDUPath");
        }
        this.sbbNotification = new SbbNotification(this.serviceID, this.sbbID);
        try {
            this.getLog().fine("Starting to test: Set trace level of the tracer ");
            this.traceMBeanProxy.setTraceLevel((NotificationSource)this.sbbNotification, "com.foo", traceLevel);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            TCKTestResult.error("ERROR!", e);
        }
        String activityName = "Test1114380Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: " + this.testName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.getLog().fine("Installing and activating service");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        SleeManagementMBeanProxy proxy = this.utils().getSleeManagementMBeanProxy();
        this.traceMBeanName = proxy.getTraceMBean();
        this.listener = new TraceNotificationListenerImpl();
        this.tracembean = new TraceMBeanProxyImpl(this.traceMBeanName, this.utils().getMBeanFacade());
        this.tracembean.addNotificationListener(this.listener, null, null);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ServiceID) {
                this.getLog().fine("Setting serviceID value.");
                this.serviceID = (ServiceID)components[i];
                continue;
            }
            if (!(components[i] instanceof SbbID)) continue;
            this.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        if (null != this.tracembean) {
            this.tracembean.removeNotificationListener(this.listener);
        }
        this.utils().getLog().fine("Disconnecting from resource");
        this.utils().getResourceInterface().clearActivities();
        this.utils().getLog().fine("Deactivating and uninstalling service");
        this.utils().deactivateAllServices();
        this.utils().uninstallAll();
    }

    private boolean doNotficationSourcesCheck(NotificationSource theNotification) {
        String alarmNotify;
        SbbNotification expectedSbbNotification = null;
        boolean passed = true;
        try {
            String notification = theNotification.toString();
            this.getLog().fine("1114213: toString() : " + notification);
            this.logSuccessfulCheck(1114213);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114213, "Incorrect Notification Name");
            return false;
        }
        expectedSbbNotification = this.sbbNotification;
        try {
            boolean areEqual = theNotification.equals(expectedSbbNotification);
            this.getLog().fine("1114216: theNotification.equals : " + theNotification + ", " + expectedSbbNotification);
            if (areEqual) {
                this.logSuccessfulCheck(1114216);
            } else {
                this.result.setFailed(1114216, ".equals() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114216, ".equals() failed");
            return false;
        }
        try {
            int areCompared = theNotification.compareTo((Object)expectedSbbNotification);
            if (areCompared == 0) {
                this.logSuccessfulCheck(1114219);
            } else {
                this.result.setFailed(1114219, ".compareTo() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114219, ".compareTo() failed");
            return false;
        }
        try {
            theNotification.hashCode();
            this.logSuccessfulCheck(1114218);
        }
        catch (Exception e) {
            this.result.setFailed(1114218, ".hashCode() failed");
            return false;
        }
        try {
            alarmNotify = theNotification.getAlarmNotificationType();
            this.getLog().fine("1114217: getAlarmNotificationType = " + alarmNotify);
            if (alarmNotify.equals("javax.slee.management.alarm.sbb")) {
                this.logSuccessfulCheck(1114217);
            } else {
                this.result.setFailed(1114217, "getAlarmNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114217, "getAlarmNotificationType() failed");
            return false;
        }
        try {
            alarmNotify = theNotification.getTraceNotificationType();
            this.getLog().fine("1114215: getTraceNotificationType = " + alarmNotify);
            if (alarmNotify.equals("javax.slee.management.trace.sbb")) {
                this.logSuccessfulCheck(1114215);
            } else {
                this.result.setFailed(1114215, "getTraceNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(1114215, "getTraceNotificationType() failed");
            return false;
        }
        try {
            alarmNotify = theNotification.getUsageNotificationType();
            this.getLog().fine("1114214: getUsageNotificationType = " + alarmNotify);
            if (alarmNotify.equals("javax.slee.management.usage.sbb")) {
                this.logSuccessfulCheck(0x110066);
            } else {
                this.result.setFailed(0x110066, "getUsageNotificationType() failed");
                passed = false;
            }
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setFailed(0x110066, "getUsageNotificationType() failed");
            return false;
        }
        return passed;
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }

    public class TraceNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            try {
                if (notification instanceof TraceNotification) {
                    TraceNotification traceNotification = (TraceNotification)notification;
                    Test1114380Test.this.getLog().fine("Received Notification from: " + traceNotification);
                    if (traceNotification.getNotificationSource() instanceof SbbNotification && traceNotification.getType().equals("javax.slee.management.trace.sbb")) {
                        NotificationSource notificationSource = traceNotification.getNotificationSource();
                        Test1114380Test.this.logSuccessfulCheck(0x11010C);
                        Test1114380Test.this.passed = Test1114380Test.this.doNotficationSourcesCheck(notificationSource);
                        Test1114380Test.this.receivedTraceNotifications++;
                    }
                }
            }
            catch (Exception e) {
                Test1114380Test.this.utils().getLog().warning(e);
                Test1114380Test.this.getLog().warning("1114380: FAILED. Received erroneous Notification Message: " + notification.getMessage());
            }
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1114235Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1114380Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " failed.", "pass", sbbTestResult);
                Test1114380Test.this.result.setPassed();
            }
            catch (TCKTestFailureException ex) {
                Test1114380Test.this.result.setFailed(ex);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1114380Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1114380Test.this.getLog().warning(exception);
            Test1114380Test.this.result.setError(exception);
        }
    }
}

