/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Collection;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.query.Equals;
import javax.slee.profile.query.GreaterThan;
import javax.slee.profile.query.GreaterThanOrEquals;
import javax.slee.profile.query.LessThan;
import javax.slee.profile.query.LessThanOrEquals;
import javax.slee.profile.query.NotEquals;
import javax.slee.profile.query.QueryExpression;
import javax.slee.profile.query.RangeMatch;

public class Test1114007Test
extends AbstractSleeTCKTest {
    public static final String SERVICE_DU_PATH_PARAM = "serviceDUPath";
    public static final String SPEC_NAME = "Test1114007Profile";
    public static final String SPEC_VERSION = "1.1";
    public static final String PROFILE_TABLE_NAME = "Test1114007ProfileTable";
    public static final String QUERY_NAME = "compareStringParam";
    public static final String QUERY_PARAM = "Test1114007Query";
    public static final String PROFILE_NAME = "Test1114007Profile_1";
    public static final QueryExpression equalsString = new Equals("stringValue", (Object)"42");
    public static final QueryExpression notEqualsString = new NotEquals("stringValue", (Object)"41");
    public static final QueryExpression greaterThanIntObj = new GreaterThan("intObjValue", (Object)new Integer(41));
    public static final QueryExpression greaterThanOrEqualsIntObj = new GreaterThanOrEquals("intObjValue", (Object)new Integer(42));
    public static final QueryExpression lessThanIntObj = new LessThan("intObjValue", (Object)new Integer(43));
    public static final QueryExpression lessThanOrEqualsIntObj = new LessThanOrEquals("intObjValue", (Object)new Integer(42));
    public static final QueryExpression rangeMatchString = new RangeMatch("stringValue", (Object)"23", (Object)"42");
    public static final int TEST_ID = 1114007;
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;

    public TCKTestResult run() throws Exception {
        try {
            ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
            this.profileProvisioning.createProfileTable(specID, PROFILE_TABLE_NAME);
            this.getLog().fine("1114007: Added profile table Test1114007ProfileTable");
            ObjectName profile = this.profileProvisioning.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
            ProfileMBeanProxy proxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
            this.utils().getMBeanFacade().setAttribute(profile, new Attribute("StringValue", "42"));
            this.utils().getMBeanFacade().setAttribute(profile, new Attribute("IntObjValue", new Integer(42)));
            this.getLog().fine("1114007: Set Attribute in profile table to: Test1114007Query");
            proxy.commitProfile();
            proxy.closeProfile();
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.failed(1114007, "ProfileProvisioningMBean has error creating ProfileTables: " + e.getClass().toString());
        }
        try {
            this.testQuery(equalsString, 1, 1114019);
            this.testQuery(notEqualsString, 1, 1114010);
            this.testQuery(greaterThanIntObj, 1, 1114013);
            this.testQuery(greaterThanOrEqualsIntObj, 1, 1114016);
            this.testQuery(lessThanIntObj, 1, 1114005);
            this.testQuery(lessThanOrEqualsIntObj, 1, 1114017);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            return TCKTestResult.error("ProfileProvisioningMBean did not perform getProfilesByStaticQuery");
        }
        this.logSuccessfulCheck(1114007);
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        this.setupService(SERVICE_DU_PATH_PARAM);
        this.getLog().fine("1114007: setUp: Create ProfileProvisioningProxy ");
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }

    private void testQuery(QueryExpression query, int expReturn, int assertionID) throws TCKTestFailureException {
        try {
            Collection col = this.profileProvisioning.getProfilesByDynamicQuery(PROFILE_TABLE_NAME, query);
            this.getLog().fine(assertionID + ": found " + col.size() + " records");
            if (col.size() != expReturn) {
                throw new TCKTestFailureException(assertionID, "The following query did not return the expected number of profiles: " + query + ". Number of found profiles was " + col.size() + ", expected " + expReturn);
            }
        }
        catch (Exception e) {
            throw new TCKTestFailureException(assertionID, "Exception occurred when executing query " + query, e);
        }
        this.logSuccessfulCheck(assertionID);
    }
}

