/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ProfileProvisioningMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;

public class Test4346Test
implements SleeTCKTest {
    private static final String PROFILE_DU_PATH_PARAM = "profileDUPath";
    private static final int TEST_ID = 4346;
    private static final String ATTRIBUTE_NAME = "AttributeA";
    private static final String PROFILE_SPEC_NAME = "Test4346ProfileCMP";
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private ProfileUtils profileUtils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioningProxy = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        if (profileSpecID == null) {
            throw new TCKTestErrorException("No ProfileSpecification found.");
        }
        ObjectName profileObj = null;
        try {
            profileProvisioningProxy.createProfileTable(profileSpecID, "Test4346ProfileTable");
            profileObj = profileProvisioningProxy.createProfile("Test4346ProfileTable", "Test4346Profile");
        }
        catch (Exception e) {
            return TCKTestResult.error("Failed to create profile table or profile.");
        }
        ProfileMBeanProxy profileProxy = this.utils.getMBeanProxyFactory().createProfileMBeanProxy(profileObj);
        try {
            int attr = this.getViaGetAttribute(profileObj);
            switch (attr) {
                case 2: {
                    TCKTestResult result = TCKTestResult.passed();
                    return result;
                }
                case 1: {
                    TCKTestResult result = TCKTestResult.failed(4346, "Exception thrown when ProfileManagement.markProfileDirty() was called.");
                    return result;
                }
                default: {
                    TCKTestResult result = TCKTestResult.error("Error during profileInitialize()");
                    return result;
                }
            }
        }
        finally {
            profileProxy.commitProfile();
        }
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing the profile spec");
        String duPath = this.utils.getTestParams().getProperty(PROFILE_DU_PATH_PARAM);
        this.utils.install(duPath);
        this.profileUtils = new ProfileUtils(this.utils);
    }

    public void tearDown() throws Exception {
        if (this.profileUtils != null) {
            ProfileProvisioningMBeanProxy profileProvisioningProxy = this.profileUtils.getProfileProvisioningProxy();
            try {
                profileProvisioningProxy.removeProfile("Test4346ProfileTable", "Test4346Profile");
            }
            catch (Exception e) {
                this.utils.getLog().warning(e);
            }
            try {
                this.profileUtils.removeProfileTable("Test4346ProfileTable");
            }
            catch (Exception e) {
                this.utils.getLog().warning(e);
            }
        }
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Uninstalling the profile spec");
        this.utils.uninstallAll();
    }

    private Integer getViaGetAttribute(ObjectName objName) throws ManagementException, TCKTestErrorException, TCKTestFailureException {
        try {
            return (Integer)this.utils.getMBeanFacade().getAttribute(objName, ATTRIBUTE_NAME);
        }
        catch (InstanceNotFoundException ie) {
            throw new TCKTestErrorException("Caught Exception while calling MBeanServer.getAttribute()", ie);
        }
        catch (ReflectionException re) {
            throw new TCKTestFailureException(4346, "Caught ReflectionException while calling MBeanServer.getAttribute(\"AttributeA\")", re);
        }
        catch (AttributeNotFoundException e) {
            throw new TCKTestFailureException(4346, "Caught AttributeNotFoundException while calling MBeanServer.getAttribute(\"AttributeA\")", e);
        }
        catch (MBeanException e) {
            Exception enclosed = e.getTargetException();
            if (enclosed instanceof ManagementException) {
                throw (ManagementException)((Object)enclosed);
            }
            if (enclosed instanceof RuntimeException) {
                throw (RuntimeException)enclosed;
            }
            throw new TCKTestErrorException("Caught unexpected exception", enclosed);
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public void onException(Exception e) throws RemoteException {
            Test4346Test.this.utils.getLog().warning("Received exception from the TCK resource");
            Test4346Test.this.utils.getLog().warning(e);
        }
    }
}

