/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.ServiceManagementMBean;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.ComponentID;
import javax.slee.InvalidStateException;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;

public class Test1616Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 1616;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        DeploymentMBeanProxy duProxy = this.utils.getDeploymentMBeanProxy();
        ServiceManagementMBeanProxy serviceProxy = this.utils.getMBeanProxyFactory().createServiceManagementMBeanProxy(this.utils.getSleeManagementMBeanProxy().getServiceManagementMBean());
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            ServiceID service;
            if (!(components[i] instanceof ServiceID) || !serviceProxy.getState(service = (ServiceID)components[i]).isInactive()) continue;
            try {
                serviceProxy.activate(service);
            }
            catch (InvalidStateException e) {
                return TCKTestResult.failed(1616, "Failed to activate a service in the inactive state.");
            }
            catch (Exception e) {
                this.utils.getLog().fine("Exception thrown: " + e);
                return TCKTestResult.error(e);
            }
            if (!serviceProxy.getState(service).isActive()) {
                return TCKTestResult.failed(1617, "activate(ServiceID) returned ok, but service was not in the active state afterwards.");
            }
            try {
                serviceProxy.activate(service);
            }
            catch (InvalidStateException e) {
                return TCKTestResult.passed();
            }
            catch (Exception e) {
                this.utils.getLog().fine("Exception thrown: " + e);
                return TCKTestResult.error(e);
            }
            return TCKTestResult.failed(1618, "InvalidStateException should have been thrown when activating an already active service.");
        }
        return TCKTestResult.error("Failed to find any services to activate.");
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils.install(duPath);
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Test1616Test.this.utils.getLog().info("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            if (passed.booleanValue()) {
                Test1616Test.this.result.setPassed();
            } else {
                Test1616Test.this.result.setFailed(1616, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test1616Test.this.utils.getLog().warning("Received exception from SBB");
            Test1616Test.this.utils.getLog().warning(e);
            Test1616Test.this.result.setError(e);
        }
    }
}

