/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.SleeManagementMBean;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.management.sleestate.QueuingSleeStateListener;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import java.util.HashMap;
import javax.slee.management.DeployableUnitID;

public class Test1880Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "duPath";
    private static final int TEST_ID = 1880;
    private SleeTCKTestUtils utils;
    private SleeManagementMBeanProxy management;
    private QueuingSleeStateListener stateListener;
    private DeployableUnitID duID;
    private QueuingResourceListener resourceListener;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public void setUp() throws Exception {
        this.management = this.utils.getSleeManagementMBeanProxy();
        this.stateListener = new QueuingSleeStateListener(this.utils);
        this.management.addNotificationListener(this.stateListener, null, null);
        this.resourceListener = new QueuingResourceListener(this.utils);
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.utils.getLog().fine("Installing " + duPath);
        this.duID = this.utils.install(duPath);
        this.utils.activateServices(this.duID, true);
    }

    public void tearDown() throws Exception {
        this.management.start();
        while (!this.stateListener.nextNotification().getNewState().isRunning()) {
        }
        try {
            this.utils.getResourceInterface().clearActivities();
        }
        catch (Exception e) {
            this.utils.getLog().error("Failed to clear activities");
        }
        this.utils.getResourceInterface().removeResourceListener();
        this.management.removeNotificationListener(this.stateListener);
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    public TCKTestResult run() throws Exception {
        this.management.stop();
        while (!this.stateListener.nextNotification().getNewState().isStopped()) {
        }
        TCKResourceTestInterface resource = this.utils.getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test1880InitialActivity");
        this.utils.getLog().fine("Firing TCKResourceEventX1 on Test1880InitialActivity.");
        try {
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        }
        catch (Exception e) {
            return TCKTestResult.passed();
        }
        this.utils.getLog().fine("Waiting for message from SBB.");
        try {
            TCKSbbMessage message = this.resourceListener.nextMessage();
            this.utils.getLog().fine("Received message from SBB.");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            if (passed.booleanValue()) {
                return TCKTestResult.passed();
            }
            this.utils.getLog().fine("Returning failed.");
            return TCKTestResult.failed(1880, (String)map.get("Message"));
        }
        catch (OperationTimedOutException e) {
            this.utils.getLog().fine("OperationTimedOutException.");
            return TCKTestResult.passed();
        }
    }
}

