/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.TraceMBean;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.impl.TraceMBeanProxyImpl;
import java.rmi.RemoteException;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;
import javax.slee.management.TraceNotification;

public class Test1114205Test
extends AbstractSleeTCKTest {
    private TCKResourceListener resourceListener;
    private NotificationListener listener;
    private FutureResult result;
    private DeployableUnitID duID;
    private String testName = "Test1114205";
    private int assertionID = 1114205;
    private SbbID sbbID;
    private ServiceID serviceID;
    private ObjectName traceMBeanName;
    private TraceMBeanProxy tracembean;
    private int receivedTraceNotifications;
    private int expectedTraceNotifications;
    private SbbNotification sbbNotification;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(FutureResult result) throws Exception {
        this.result = result;
        if (this.getTestName().equals("SEVERE")) {
            this.expectedTraceNotifications = 1;
            this.receivedTraceNotifications = 0;
            this.doTest1114205Test(TraceLevel.SEVERE);
        } else if (this.getTestName().equals("WARNING")) {
            this.expectedTraceNotifications = 3;
            this.receivedTraceNotifications = 0;
            this.doTest1114205Test(TraceLevel.WARNING);
        } else if (this.getTestName().equals("INFO")) {
            this.expectedTraceNotifications = 6;
            this.receivedTraceNotifications = 0;
            this.doTest1114205Test(TraceLevel.INFO);
        } else if (this.getTestName().equals("CONFIG")) {
            this.expectedTraceNotifications = 10;
            this.receivedTraceNotifications = 0;
            this.doTest1114205Test(TraceLevel.CONFIG);
        } else if (this.getTestName().equals("FINE")) {
            this.expectedTraceNotifications = 15;
            this.receivedTraceNotifications = 0;
            this.doTest1114205Test(TraceLevel.FINE);
        } else if (this.getTestName().equals("FINER")) {
            this.expectedTraceNotifications = 21;
            this.receivedTraceNotifications = 0;
            this.doTest1114205Test(TraceLevel.FINER);
        } else if (this.getTestName().equals("FINEST")) {
            this.expectedTraceNotifications = 28;
            this.receivedTraceNotifications = 0;
            this.doTest1114205Test(TraceLevel.FINEST);
        }
        Test1114205Test test1114205Test = this;
        synchronized (test1114205Test) {
            this.wait(this.utils().getTestTimeout());
        }
        if (this.expectedTraceNotifications != this.receivedTraceNotifications) {
            result.setFailed(1114205, "Expected number of trace messages not received, traces were not delivered by the TraceFacility (expected " + this.expectedTraceNotifications + ", received " + this.receivedTraceNotifications + ")");
        }
    }

    public void doTest1114205Test(TraceLevel traceLevel) throws Exception {
        if (this.sbbID == null) {
            throw new TCKTestErrorException("sbbID not found for serviceDUPath");
        }
        if (this.serviceID == null) {
            throw new TCKTestErrorException("serviceID not found for serviceDUPath");
        }
        TraceMBeanProxy traceMBeanProxy = this.utils().getMBeanProxyFactory().createTraceMBeanProxy(this.utils().getSleeManagementMBeanProxy().getTraceMBean());
        this.sbbNotification = new SbbNotification(this.serviceID, this.sbbID);
        try {
            this.getLog().fine("Starting to test The trace level of a particular tracer is equal to the trace level assigned to it by an Administrator using a TraceMBean object.");
            traceMBeanProxy.setTraceLevel((NotificationSource)this.sbbNotification, "com.foo", traceLevel);
        }
        catch (Exception e) {
            this.getLog().warning(e);
            this.result.setError("ERROR setTraceLevel ", e);
        }
        String activityName = "Test1114205Test";
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(activityName);
        this.getLog().info("Firing event: " + this.testName);
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", this.testName, activityID, null);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Connecting to resource");
        this.getLog().fine("Installing and activating service");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        String duPath = this.utils().getTestParams().getProperty("serviceDUPath");
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        SleeManagementMBeanProxy proxy = this.utils().getSleeManagementMBeanProxy();
        this.traceMBeanName = proxy.getTraceMBean();
        this.listener = new TraceNotificationListenerImpl();
        this.tracembean = new TraceMBeanProxyImpl(this.traceMBeanName, this.utils().getMBeanFacade());
        this.tracembean.addNotificationListener(this.listener, null, null);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof ServiceID) {
                this.getLog().fine("Setting serviceID value.");
                this.serviceID = (ServiceID)components[i];
                continue;
            }
            if (!(components[i] instanceof SbbID)) continue;
            this.getLog().fine("Setting sbbID value.");
            this.sbbID = (SbbID)components[i];
        }
    }

    public void tearDown() throws Exception {
        if (null != this.tracembean) {
            this.tracembean.removeNotificationListener(this.listener);
        }
        super.tearDown();
    }

    public String getTestName() {
        String testName = "testName";
        return this.utils().getTestParams().getProperty(testName);
    }

    private void logSuccessfulCheck(int assertionID) {
        this.utils().getLog().info("Check for assertion " + assertionID + " OK");
    }

    public class TraceNotificationListenerImpl
    implements NotificationListener {
        public final void handleNotification(Notification notification, Object handback) {
            if (notification instanceof TraceNotification) {
                TraceNotification traceNotification = (TraceNotification)notification;
                if (!traceNotification.getNotificationSource().equals(Test1114205Test.this.sbbNotification)) {
                    return;
                }
                Test1114205Test.this.getLog().fine("Received Trace Notification from: " + traceNotification);
                if (traceNotification.getMessage().equals("SEVERE:Test1114205TraceMessage")) {
                    Test1114205Test.this.receivedTraceNotifications = Test1114205Test.this.receivedTraceNotifications + 1;
                } else if (traceNotification.getMessage().equals("WARNING:Test1114205TraceMessage")) {
                    Test1114205Test.this.receivedTraceNotifications = Test1114205Test.this.receivedTraceNotifications + 2;
                } else if (traceNotification.getMessage().equals("INFO:Test1114205TraceMessage")) {
                    Test1114205Test.this.receivedTraceNotifications = Test1114205Test.this.receivedTraceNotifications + 3;
                    Test1114205Test.this.logSuccessfulCheck(1114205);
                    if (traceNotification.getNotificationSource().equals(Test1114205Test.this.sbbNotification)) {
                        Test1114205Test.this.logSuccessfulCheck(1114210);
                    } else {
                        Test1114205Test.this.result.setFailed(1114210, "NotificationSource does not equal sbbNotification.");
                    }
                    String traceNotifyStr = "SbbNotification[service=ServiceID[name=Test1114205Service,vendor=jain.slee.tck,version=1.1],sbb=SbbID[name=Test1114205Sbb,vendor=jain.slee.tck,version=1.1]]";
                    String traceStrVal = traceNotification.getNotificationSource().toString();
                    Test1114205Test.this.utils().getLog().fine("" + traceStrVal);
                    Test1114205Test.this.getLog().fine("Trace Notification is: " + traceStrVal);
                    if (traceStrVal.equals(traceNotifyStr)) {
                        Test1114205Test.this.logSuccessfulCheck(1114203);
                    } else {
                        Test1114205Test.this.result.setFailed(1114203, "toString() returned incorrect NotificationSource");
                    }
                    if (traceNotification.getTracerName().equals("com.foo")) {
                        Test1114205Test.this.logSuccessfulCheck(0x110060);
                    } else {
                        Test1114205Test.this.result.setFailed(0x110060, "Received erroneous Trace Name: " + traceNotification.getTracerName());
                    }
                    if (traceNotification.getTraceLevel() == TraceLevel.INFO) {
                        Test1114205Test.this.logSuccessfulCheck(1114202);
                    } else {
                        Test1114205Test.this.result.setFailed(1114202, "Received erroneous Trace Level: " + traceNotification.getTraceLevel());
                    }
                    if (traceNotification.getMessage().equals("INFO:Test1114205TraceMessage")) {
                        Test1114205Test.this.logSuccessfulCheck(1114206);
                    } else {
                        Test1114205Test.this.result.setFailed(1114206, "Received erroneous Trace Message: " + traceNotification.getMessage());
                    }
                    if (traceNotification.getCause() == null) {
                        Test1114205Test.this.logSuccessfulCheck(1114200);
                    } else {
                        Test1114205Test.this.result.setFailed(1114200, "Received erroneous Trace Cause: " + traceNotification.getCause());
                    }
                } else if (traceNotification.getMessage().equals("CONFIG:Test1114205TraceMessage")) {
                    Test1114205Test.this.receivedTraceNotifications = Test1114205Test.this.receivedTraceNotifications + 4;
                    Test1114205Test.this.result.setFailed(1114205, "setFailed. Received erroneous Trace message");
                } else if (traceNotification.getMessage().equals("FINE:Test1114205TraceMessage")) {
                    Test1114205Test.this.receivedTraceNotifications = Test1114205Test.this.receivedTraceNotifications + 5;
                    Test1114205Test.this.result.setFailed(1114205, "setFailed. Received erroneous Trace message");
                } else if (traceNotification.getMessage().equals("FINER:Test1114205TraceMessage")) {
                    Test1114205Test.this.receivedTraceNotifications = Test1114205Test.this.receivedTraceNotifications + 6;
                    Test1114205Test.this.result.setFailed(1114205, "setFailed. Received erroneous Trace message");
                } else if (traceNotification.getMessage().equals("FINEST:Test1114205TraceMessage")) {
                    Test1114205Test.this.receivedTraceNotifications = Test1114205Test.this.receivedTraceNotifications + 7;
                    Test1114205Test.this.result.setFailed(1114205, "setFailed. Received erroneous Trace message");
                }
                if (!Test1114205Test.this.result.isSet()) {
                    Test1114205Test.this.result.setPassed();
                }
                return;
            }
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            Map sbbData = (Map)message.getMessage();
            String sbbTestName = "Test1114205Test";
            String sbbTestResult = (String)sbbData.get("result");
            String sbbTestMessage = (String)sbbData.get("message");
            int assertionID = (Integer)sbbData.get("id");
            Test1114205Test.this.getLog().info("Received message from SBB: testname=" + sbbTestName + ", result=" + sbbTestResult + ", message=" + sbbTestMessage + ", id=" + assertionID);
            try {
                Assert.assertEquals(assertionID, "Test " + sbbTestName + " setFailed.", "pass", sbbTestResult);
                Test1114205Test.this.result.setPassed();
            }
            catch (TCKTestFailureException ex) {
                Test1114205Test.this.result.setFailed(ex);
            }
        }

        public void onException(Exception exception) throws RemoteException {
            Test1114205Test.this.getLog().warning("Received Exception from SBB or resource:");
            Test1114205Test.this.getLog().warning(exception);
            Test1114205Test.this.result.setError(exception);
        }
    }
}

