/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.sleestate;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testutils.ExceptionsUtil;
import javax.slee.InvalidStateException;
import javax.slee.management.SleeState;

public class ShutdownFailsFromRunning
implements SleeTCKTest {
    private SleeTCKTestUtils utils;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public TCKTestResult run() throws Exception {
        SleeState currentState = this.utils.getSleeManagementMBeanProxy().getState();
        if (!currentState.isRunning()) {
            return TCKTestResult.error("Expected SLEE to be in RUNNING state prior to test run, but current state is " + currentState);
        }
        try {
            this.utils.getSleeManagementMBeanProxy().shutdown();
        }
        catch (InvalidStateException ise) {
            return TCKTestResult.passed();
        }
        catch (Exception e) {
            return TCKTestResult.failed(4034, "SleeManagementMBean.shutdown() did not throw an InvalidStateException; it threw another Exception:" + ExceptionsUtil.formatThrowable(e));
        }
        return TCKTestResult.failed(4034, "SleeManagementMBean.shutdown() did not throw an InvalidStateException");
    }
}

