/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.management.sleestate;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.management.sleestate.QueuingSleeStateListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.SleeManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.statetracking.DirectionalGraph;
import com.opencloud.util.SleepUtil;
import java.rmi.RemoteException;
import java.util.Arrays;
import javax.slee.InvalidStateException;
import javax.slee.management.ManagementException;
import javax.slee.management.SleeState;
import javax.slee.management.SleeStateChangeNotification;

public class SleeStateMachineTest
extends AbstractSleeTCKTest {
    private static final String WAIT_DURING_STOPPING_PARAM = "waitDuringStopping";
    private ResourceListenerImpl resourceListener;
    private QueuingSleeStateListener stateListener;
    private SleeManagementMBeanProxy management;
    private DirectionalGraph validChangesGraph;
    private long waitDuringStopping;
    private Exception exceptionFromResource;
    private SleeState previousNewState;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TCKTestResult run() throws Exception {
        SleeState currentState;
        block16: {
            currentState = this.getCurrentState();
            if (!currentState.isRunning()) {
                throw new TCKTestErrorException("Expected SLEE to be in RUNNING state as a pre-condition of TCK tests. Current state:" + currentState);
            }
            this.getLog().info("In the RUNNING state");
            this.getLog().info("Firing an event on activity A to attach an Sbb to A");
            TCKResourceTestInterface resource = this.utils().getResourceInterface();
            TCKActivityID activityID = resource.createActivity("tck.SleeStateMachineTest.ActivityA");
            resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activityID, null);
            this.waitForSbbAttach();
            this.getLog().info("The Sbb is attached to the activity");
            this.attemptInvalidStart();
            try {
                this.getLog().info("Calling stop()");
                this.management.stop();
            }
            catch (InvalidStateException ise) {
                throw new TCKTestFailureException(4028, "SleeManagementMBean.stop() threw an InvalidStateException from the RUNNING state", (Exception)((Object)ise));
            }
            if (this.getCurrentState().isStopped()) {
                if (!this.resourceListener.hasActivityEnded()) throw new TCKTestFailureException(1886, "The SLEE moved to the STOPPED state before all activities were ended");
                this.getLog().warning("The SLEE automatically detached the activity, presumably as a result of a timeout, and appeared to do so while during the stop() method. If the time taken in stop() was large, this indicated an illegally blocking implementation of stop(). If small, this indicates an overly small timeout for ending activities.");
            }
            this.waitForStateChange(1490, SleeState.STOPPING, false);
            if (this.getCurrentState().isRunning()) {
                throw new TCKTestFailureException(4166, "The SLEE fired a state change notification for the STOPPING state before leaving the RUNNING state.");
            }
            this.getLog().info("Waiting " + this.waitDuringStopping + " ms in the STOPPING state to ensure the SLEE doesn't " + "move to the STOPPED state before the activity has ended");
            SleepUtil.sleepFor(this.waitDuringStopping);
            currentState = this.getCurrentState();
            this.getLog().info("Stopped waiting. Now in the " + currentState + " state");
            if (!currentState.isStopping()) {
                if (!currentState.isStopped()) throw new TCKTestErrorException("The SLEE unexpected changed to the " + currentState + " state (sometime after entering the STOPPED state)");
                if (!this.resourceListener.hasActivityEnded()) throw new TCKTestFailureException(1886, "The SLEE moved to the STOPPED state before all activities were ended");
                this.getLog().warning("The SLEE automatically detached the activity, presumably as a result of a timeout");
            }
            if (!currentState.isStopped()) {
                this.attemptInvalidStart();
                this.attemptInvalidStop();
            }
            this.getLog().info("Ending the activity to trigger a change to the STOPPED state (if not changed already)");
            if (resource.isLive(activityID)) {
                try {
                    resource.endActivity(activityID);
                }
                catch (Exception ex) {
                    this.getLog().warning("Caught Exception while trying to end the activity:");
                    this.getLog().warning(ex);
                    if (!resource.isLive(activityID)) break block16;
                    throw ex;
                }
            }
        }
        this.waitForStateChange(1887, SleeState.STOPPED, true);
        currentState = this.getCurrentState();
        if (currentState.isRunning() || currentState.isStopping()) {
            throw new TCKTestFailureException(4166, "The SLEE fired a state change notification for the STOPPED state before entering that state.");
        }
        this.attemptInvalidStop();
        try {
            this.getLog().info("Calling start() from the STOPPED state");
            this.management.start();
        }
        catch (InvalidStateException ise) {
            throw new TCKTestFailureException(4022, "SleeManagementMBean.start() threw an InvalidStateException from the STOPPED state", (Exception)((Object)ise));
        }
        this.waitForStateChange(1487, SleeState.STARTING, false);
        currentState = this.getCurrentState();
        if (currentState.isStopped()) {
            throw new TCKTestFailureException(4166, "The SLEE fired a state change notification for the STARTING state before leaving the STOPPED state.");
        }
        if (!currentState.isStarting() && !currentState.isRunning()) {
            throw new TCKTestFailureException(1487, "The SLEE was in an unexpected state after receiving a notification of change to the STARTING state:" + currentState);
        }
        this.attemptInvalidStart();
        this.waitForStateChange(1883, SleeState.RUNNING, true);
        currentState = this.getCurrentState();
        if (currentState.isStopped() || currentState.isStarting()) {
            throw new TCKTestFailureException(4166, "The SLEE fired a state change notification for the RUNNING state before entering that state.");
        }
        this.getLog().info("Back in the RUNNING state");
        if (this.exceptionFromResource == null) return TCKTestResult.passed();
        return TCKTestResult.error("Exception received from TCK resource", this.exceptionFromResource);
    }

    public void setUp() throws Exception {
        this.buildStateMachineModel();
        this.resourceListener = new ResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
        this.management = this.utils().getSleeManagementMBeanProxy();
        this.stateListener = new QueuingSleeStateListener(this.utils());
        this.management.addNotificationListener(this.stateListener, null, null);
        this.waitDuringStopping = Long.parseLong(this.utils().getTestParams().getProperty(WAIT_DURING_STOPPING_PARAM));
        super.setUp();
    }

    public void tearDown() throws Exception {
        if (this.management != null) {
            this.management.removeNotificationListener(this.stateListener);
        }
        this.stateListener = null;
        this.resourceListener = null;
        this.management = null;
        super.tearDown();
    }

    private void waitForStateChange(int assertionReArrival, SleeState expectedState, boolean checkNoFurtherTransitions) throws TCKTestFailureException, TCKTestErrorException, ManagementException {
        SleeStateChangeNotification stateChange = null;
        try {
            this.getLog().info("Waiting to move to the " + expectedState + " state");
            stateChange = this.stateListener.nextNotification();
            this.getLog().info("Found state change: " + stateChange);
        }
        catch (OperationTimedOutException toe) {
            SleeState currentState = this.getCurrentState();
            if (this.previousNewState != null && !currentState.equals((Object)this.previousNewState)) {
                throw new TCKTestFailureException(1469, "The SLEE moved from the " + this.previousNewState + " state to the " + currentState + " state without delivering a SleeStateChangeNotification");
            }
            throw new TCKTestFailureException(assertionReArrival, "Timed out waiting for the " + expectedState + " state");
        }
        this.checkTransition(stateChange);
        if (!stateChange.getNewState().equals((Object)expectedState)) {
            throw new TCKTestErrorException("Received a legal but unexpected state change. Expected state: " + expectedState + ". State change received: " + stateChange);
        }
        try {
            stateChange.toString();
        }
        catch (Exception e) {
            throw new TCKTestFailureException(4173, "SleeStateChangeNotification.toString() threw exception.");
        }
        if (stateChange.toString() == null) {
            throw new TCKTestFailureException(4173, "SleeStateChangeNotification.toString() returned null.");
        }
        if (checkNoFurtherTransitions) {
            if (this.stateListener.hasNotifications()) {
                stateChange = this.stateListener.nextNotification();
                this.checkTransition(stateChange);
                throw new TCKTestErrorException("The SLEE transitioned unexpectedly from the " + stateChange.getOldState() + " to the " + stateChange.getNewState() + " state");
            }
            SleeState currentState = this.getCurrentState();
            if (!stateChange.getNewState().equals((Object)currentState)) {
                throw new TCKTestFailureException(4169, "SleeManagementMBean.getState() returns " + currentState + ", but last received state Notification was to the " + this.previousNewState + " state");
            }
        }
    }

    private void checkTransition(SleeStateChangeNotification stateChange) throws TCKTestFailureException {
        SleeState oldState = stateChange.getOldState();
        SleeState newState = stateChange.getNewState();
        if (oldState == null) {
            throw new TCKTestFailureException(4169, "SleeStateChangeNotification.getOldState() returned null. Notification:" + stateChange);
        }
        if (newState == null) {
            throw new TCKTestFailureException(4171, "SleeStateChangeNotification.getNewState() returned null. Notification:" + stateChange);
        }
        if (!this.validChangesGraph.isEdge(oldState.toInt(), newState.toInt())) {
            throw new TCKTestFailureException(1983, "The SLEE sent a notification which describes an invalid state change from the " + oldState + " state to the " + newState + " state");
        }
        if (this.previousNewState != null && !oldState.equals((Object)this.previousNewState)) {
            throw new TCKTestFailureException(4171, "SleeStateChangeNotification.getOldState() returned " + oldState + ", which does not match the state returned by the getNewState() from the previous notification: " + this.previousNewState);
        }
        this.previousNewState = newState;
    }

    private void attemptInvalidStart() throws Exception {
        SleeState preCallState = this.getCurrentState();
        try {
            if (preCallState.isStopped()) {
                throw new TCKTestErrorException("attemptInvalidStart() may not be called from the STOPPED state");
            }
            this.getLog().info("Attempting invalid call to start() from the " + preCallState + " state");
            this.management.start();
            throw new TCKTestFailureException(4022, "ManagementMBean.start() did not throw an InvalidStateException when invoked from the " + preCallState + " state");
        }
        catch (InvalidStateException e) {
            this.getLog().info("Caught expected InvalidStateException from SleeManagementMBean.start() in " + preCallState + " state");
            SleeState postCallState = this.getCurrentState();
            if (!(postCallState.equals((Object)preCallState) || preCallState.isStarting() && postCallState.isRunning() || preCallState.isStopping() && postCallState.isStopped())) {
                throw new TCKTestFailureException(1486, "SleeManagementMBean.start() threw the expected InvalidStateException, but resulted in an unexpected state change from the " + preCallState + " state to the " + postCallState + " state");
            }
            return;
        }
    }

    private void attemptInvalidStop() throws Exception {
        SleeState preCallState = this.getCurrentState();
        try {
            if (!preCallState.isStopped() && !preCallState.isStopping()) {
                throw new TCKTestErrorException("attemptInvalidStop() may only be called from the STOPPED or STOPPING state");
            }
            this.getLog().info("Attempting invalid call to stop() from the " + preCallState + " state");
            this.management.stop();
            throw new TCKTestFailureException(4028, "ManagementMBean.stop() did not throw an InvalidStateException when invoked from the " + preCallState + " state");
        }
        catch (InvalidStateException e) {
            this.getLog().info("Caught expected InvalidStateException from SleeManagementMBean.stop() in " + preCallState + " state");
            SleeState postCallState = this.getCurrentState();
            if (!(postCallState.equals((Object)preCallState) || preCallState.isStopping() && postCallState.isStopped())) {
                throw new TCKTestFailureException(1489, "SleeManagementMBean.stop() threw the expected InvalidStateException, but resulted in an unexpected state change from the " + preCallState + " state to the " + postCallState + " state");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSbbAttach() throws OperationTimedOutException {
        ResourceListenerImpl resourceListenerImpl = this.resourceListener;
        synchronized (resourceListenerImpl) {
            long now = System.currentTimeMillis();
            long timeoutAt = now + (long)this.utils().getTestTimeout();
            while (timeoutAt > now && !this.resourceListener.hasSbbAttached()) {
                try {
                    this.resourceListener.wait(timeoutAt - now);
                    now = System.currentTimeMillis();
                }
                catch (InterruptedException ie) {}
            }
            if (!this.resourceListener.hasSbbAttached()) {
                throw new OperationTimedOutException("Timed out while waiting for the Sbb to receive an event");
            }
        }
    }

    private SleeState getCurrentState() throws TCKTestFailureException, TCKTestErrorException, ManagementException {
        SleeState currentState = this.management.getState();
        if (currentState == null) {
            throw new TCKTestFailureException(1483, "SleeManagementMBean.getState() returned null");
        }
        return currentState;
    }

    private void buildStateMachineModel() {
        int[] allStates = new int[]{0, 1, 2, 3};
        Arrays.sort(allStates);
        this.validChangesGraph = new DirectionalGraph(allStates);
        this.validChangesGraph.addEdge(0, 1);
        this.validChangesGraph.addEdge(1, 2);
        this.validChangesGraph.addEdge(1, 3);
        this.validChangesGraph.addEdge(2, 3);
        this.validChangesGraph.addEdge(3, 0);
    }

    private class ResourceListenerImpl
    extends BaseTCKResourceListener {
        private boolean hasSbbAttached;
        private boolean hasActivityEnded;

        private ResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            this.hasSbbAttached = true;
            SleeStateMachineTest.this.getLog().info("ResourceListenerImpl: received message from Sbb");
            this.notifyAll();
        }

        public synchronized void onActivityContextInvalid(TCKActivityID activityID) throws RemoteException {
            this.hasActivityEnded = true;
            SleeStateMachineTest.this.getLog().info("ResourceListenerImpl: received notification of activity end");
            this.notifyAll();
        }

        public void onException(Exception e) {
            SleeStateMachineTest.this.exceptionFromResource = e;
            SleeStateMachineTest.this.utils().getLog().warning("Received Exception from resource:");
            SleeStateMachineTest.this.utils().getLog().warning(e);
        }

        public synchronized boolean hasSbbAttached() {
            return this.hasSbbAttached;
        }

        public synchronized boolean hasActivityEnded() {
            return this.hasActivityEnded;
        }
    }
}

