/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.profileutils.BaseMessageAdapter;
import com.opencloud.sleetck.lib.rautils.MessageHandlerRegistry;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;

public abstract class ProfileRAInteractionBaseTest
extends AbstractSleeTCKTest {
    private static final String RA_VENDOR = "jain.slee.tck";
    private static final String RA_VERSION = "1.1";
    private static final String SPEC_VERSION = "1.0";
    private static final String PROFILE_SPEC_DU_PATH_PARAM = "ProfileSpecDUPath";
    private static final String RESOURCE_DU_PATH_PARAM = "RADUPath";
    private MessageHandlerRegistry out;
    private RMIObjectChannel in;
    private FutureResult futureResult;
    private ProfileUtils profileUtils;
    private ProfileProvisioningMBeanProxy profileProvisioning;

    public abstract String getRAName();

    public abstract String getSpecName();

    public abstract String[] getProfileTableNames();

    public abstract String[] getProfileNames(String var1);

    public TCKTestResult run() throws Exception {
        String raName = this.getRAName();
        String raEntityName = raName + "_Entity";
        this.futureResult = new FutureResult(this.getLog());
        ResourceManagementMBeanProxy resourceMBean = this.utils().getResourceManagementMBeanProxy();
        ResourceAdaptorID raID = new ResourceAdaptorID(raName, RA_VENDOR, RA_VERSION);
        ConfigProperties configProperties = new ConfigProperties();
        resourceMBean.createResourceAdaptorEntity(raID, raEntityName, configProperties);
        resourceMBean.activateResourceAdaptorEntity(raEntityName);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("Type", new Integer(1));
        this.out.sendMessage(map);
        return this.futureResult.waitForResult(this.utils().getTestTimeout());
    }

    private void setupProfile(String profileTableName, String profileName) throws Exception {
        ObjectName profile = this.profileProvisioning.createProfile(profileTableName, profileName);
        ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.getLog().fine("Created profile " + profileName + " for profile table " + profileTableName);
        profileProxy.commitProfile();
        profileProxy.closeProfile();
        this.getLog().fine("Commit and close profile " + profileName);
    }

    private void setupProfileTable(String profileTableName) throws Exception {
        String specName = this.getSpecName();
        ProfileSpecificationID specID = new ProfileSpecificationID(specName, RA_VENDOR, SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, profileTableName);
        this.getLog().fine("Added profile table " + profileTableName);
        String[] profiles = this.getProfileNames(profileTableName);
        for (int i = 0; i < profiles.length; ++i) {
            this.setupProfile(profileTableName, profiles[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.in.clearQueue();
            this.utils().removeRAEntities();
            String[] profileTables = this.getProfileTableNames();
            try {
                for (int i = 0; i < profileTables.length; ++i) {
                    this.profileUtils.removeProfileTable(profileTables[i]);
                }
            }
            catch (Exception e) {
                this.getLog().warning("Exception when trying to remove profile table: ");
                this.getLog().warning(e);
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected void setPassed(int assertionID, String msg) {
        this.getLog().fine(assertionID + ": " + msg);
        if (this.futureResult != null && !this.futureResult.isSet()) {
            this.futureResult.setPassed();
        }
    }

    protected void setFailed(int assertionID, String msg, Exception e) {
        if (e == null) {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(assertionID, msg);
            }
        } else {
            this.getLog().fine("FAILURE: " + assertionID + ":" + msg);
            this.getLog().fine(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setFailed(new TCKTestFailureException(assertionID, msg, e));
            }
        }
    }

    protected void setError(String msg, Exception e) {
        if (e == null) {
            this.getLog().warning(msg);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg);
            }
        } else {
            this.getLog().warning(msg);
            this.getLog().warning(e);
            if (this.futureResult != null && !this.futureResult.isSet()) {
                this.futureResult.setError(msg, e);
            }
        }
    }

    public void setUp() throws Exception {
        this.setupService(PROFILE_SPEC_DU_PATH_PARAM);
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        this.setupService(RESOURCE_DU_PATH_PARAM);
        this.in = this.utils().getRMIObjectChannel();
        this.in.setMessageHandler(new BaseMessageAdapter(this.getLog()){

            public void onSetPassed(int assertionID, String msg) {
                ProfileRAInteractionBaseTest.this.setPassed(assertionID, msg);
            }

            public void onSetFailed(int assertionID, String msg, Exception e) {
                ProfileRAInteractionBaseTest.this.setFailed(assertionID, msg, e);
            }

            public void onLogCall(String msg) {
                ProfileRAInteractionBaseTest.this.getLog().fine(msg);
            }

            public void onSetError(String msg, Exception e) {
                ProfileRAInteractionBaseTest.this.setError(msg, e);
            }
        });
        this.out = this.utils().getMessageHandlerRegistry();
        String[] profileTables = this.getProfileTableNames();
        for (int i = 0; i < profileTables.length; ++i) {
            this.getLog().fine("Starting to setup table: " + profileTables[i]);
            this.setupProfileTable(profileTables[i]);
        }
    }
}

