/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.checkprofileload;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.profiles.checkprofileload.CheckLoadProfileProxy;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class CheckProfileLoadTest
extends AbstractSleeTCKTest {
    private static final String TABLE_NAME = "tck.CheckLLoadProfileTest.table";
    private static final String PROFILE_SPEC_NAME = "CheckLoadProfile";
    private static final int ASSERTION_ID = 4337;
    private ProfileUtils profileUtils;
    private Vector activeProxies;
    private boolean isTableCreated;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.CheckLLoadProfileTest.table");
        profileProvisioning.createProfileTable(profileSpecID, TABLE_NAME);
        this.isTableCreated = true;
        ObjectName defaultProfileName = profileProvisioning.getDefaultProfile(TABLE_NAME);
        CheckLoadProfileProxy proxy = this.getProfileProxy(defaultProfileName);
        proxy.editProfile();
        if (proxy.wasProfileLoadCalled()) {
            if (proxy.wasCMPReadSuccessful()) {
                this.getLog().info("The profile management object reported that profileLoad() was called, and that a CMP read was successful, indicating an active transaction context");
                return TCKTestResult.passed();
            }
            return TCKTestResult.failed(4337, "profileLoad() should have been called in a transactional context, but failed to read a CMP field value from profileLoad(). Failure reason as reported by the profile management implementation: " + proxy.getFailureReason());
        }
        return TCKTestResult.failed(4337, "profileLoad() wasn't called on the profile management object anytime before an invocation of a custom management method (wasProfileLoadCalled()). profileLoad() was expected to be called, and within an active transaction context.");
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
        this.activeProxies = new Vector();
    }

    public void tearDown() throws Exception {
        if (this.activeProxies != null) {
            this.getLog().fine("Closing profiles");
            Iterator activeProxiesIter = this.activeProxies.iterator();
            while (activeProxiesIter.hasNext()) {
                CheckLoadProfileProxy aProxy = (CheckLoadProfileProxy)activeProxiesIter.next();
                try {
                    if (aProxy == null) continue;
                    if (aProxy.isProfileWriteable()) {
                        aProxy.restoreProfile();
                    }
                    aProxy.closeProfile();
                }
                catch (Exception ex) {
                    this.getLog().warning("Exception caught while trying to close profiles:");
                    this.getLog().warning(ex);
                }
            }
        }
        try {
            if (this.profileUtils != null && this.isTableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        this.profileUtils = null;
        this.isTableCreated = false;
        this.activeProxies = null;
        super.tearDown();
    }

    private CheckLoadProfileProxy getProfileProxy(ObjectName mbeanName) {
        CheckLoadProfileProxy rProxy = new CheckLoadProfileProxy(mbeanName, this.utils().getMBeanFacade());
        this.activeProxies.addElement(rProxy);
        return rProxy;
    }
}

