/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.defaultprofile;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.profiles.defaultprofile.CheckInitializeProfileProxy;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import javax.management.ObjectName;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public class CheckInitializeProfileTest
extends AbstractSleeTCKTest {
    private static final String TABLE_NAME = "tck.CheckInitializeProfileTest.table";
    private static final String PROFILE_SPEC_NAME = "CheckInitializeProfile";
    private ProfileUtils profileUtils;
    private boolean isTableCreated;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.CheckInitializeProfileTest.table");
        profileProvisioning.createProfileTable(profileSpecID, TABLE_NAME);
        this.isTableCreated = true;
        ObjectName defaultProfileName = profileProvisioning.getDefaultProfile(TABLE_NAME);
        CheckInitializeProfileProxy defaultProfileProxy = this.getProfileProxy(defaultProfileName);
        this.getLog().info("Checking default profile");
        String initialValue = defaultProfileProxy.getValue();
        if (initialValue == null) {
            throw new TCKTestFailureException(924, "The default profile was not initialized.");
        }
        Assert.assertEquals(924, "The default profile was initialized to an unexpected value", "INITIALIZED", initialValue);
        String initialValue2 = defaultProfileProxy.getValue2();
        this.getLog().info("initial Value2:" + initialValue2);
        if (initialValue2 == null) {
            throw new TCKTestFailureException(4330, "profileInitialize did not initialize the profile's transient fields");
        }
        Assert.assertEquals(4330, "profileInitialize initialized the profile's transient fields to an unexpected value", "INITIALIZED", initialValue2);
        this.getLog().info("Creating and checking a new profile");
        ObjectName firstNewProfileName = profileProvisioning.createProfile(TABLE_NAME, "FirstProfile");
        CheckInitializeProfileProxy firstNewProfileProxy = this.getProfileProxy(firstNewProfileName);
        initialValue = firstNewProfileProxy.getValue();
        Assert.assertEquals(926, "A new profile did not take its values from the default profile", "INITIALIZED", initialValue);
        String newDefaultValue = "Changed";
        this.getLog().info("Editing default profile for table tck.CheckInitializeProfileTest.table");
        defaultProfileProxy.editProfile();
        defaultProfileProxy.setValue(newDefaultValue);
        defaultProfileProxy.commitProfile();
        defaultProfileProxy.closeProfile();
        this.getLog().info("Creating and checking another new profile");
        ObjectName secondNewProfileName = profileProvisioning.createProfile(TABLE_NAME, "SecondProfile");
        CheckInitializeProfileProxy secondNewProfileProxy = this.getProfileProxy(secondNewProfileName);
        initialValue = secondNewProfileProxy.getValue();
        if (!newDefaultValue.equals(initialValue)) {
            if (initialValue.equals("INITIALIZED")) {
                Assert.fail(926, "A new profile did not take its values from the current version of the default profile; it copied its values from the initial version of the default profile");
            } else {
                Assert.fail(926, "A new profile did not take its values from the default profile. Current default value=" + newDefaultValue + ", value in new profile=" + initialValue);
            }
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
    }

    public void tearDown() throws Exception {
        try {
            if (this.profileUtils != null && this.isTableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        this.profileUtils = null;
        this.isTableCreated = false;
        super.tearDown();
    }

    private CheckInitializeProfileProxy getProfileProxy(ObjectName mbeanName) throws TCKTestErrorException, UnrecognizedProfileNameException, UnrecognizedProfileTableNameException, ManagementException {
        CheckInitializeProfileProxy rProxy = new CheckInitializeProfileProxy(mbeanName, this.utils().getMBeanFacade());
        return rProxy;
    }
}

