/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.events;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEvent;
import com.opencloud.sleetck.lib.sbbutils.events.TCKSbbEventImpl;
import com.opencloud.sleetck.lib.testsuite.profiles.events.ProfileEventsTestEventData;
import com.opencloud.sleetck.lib.testsuite.profiles.simpleprofile.SimpleProfileCMP;
import com.opencloud.sleetck.lib.testutils.Assert;
import javax.naming.Context;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.ComponentID;
import javax.slee.TransactionRequiredLocalException;
import javax.slee.facilities.Level;
import javax.slee.profile.ProfileAddedEvent;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileID;
import javax.slee.profile.ProfileRemovedEvent;
import javax.slee.profile.ProfileTableActivity;
import javax.slee.profile.ProfileTableActivityContextInterfaceFactory;
import javax.slee.profile.ProfileUpdatedEvent;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;

public abstract class ProfileEventsTestSbb
extends BaseTCKSbb {
    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.FINE, "Received TCKResourceEventX event", null);
            ProfileEventsTestEventData eventData = ProfileEventsTestEventData.fromExported(event.getMessage());
            this.setProfileTableName(eventData.getProfileTableName());
            this.setFirstProfileName(eventData.getFirstProfileName());
            this.setSecondProfileName(eventData.getSecondProfileName());
            Context env = TCKSbbUtils.getSbbEnvironment();
            ProfileFacility profileFacility = (ProfileFacility)env.lookup("slee/facilities/profile");
            ProfileTableActivity tableActivity = profileFacility.getProfileTableActivity(eventData.getProfileTableName());
            ProfileTableActivityContextInterfaceFactory profileTableACIFactory = (ProfileTableActivityContextInterfaceFactory)env.lookup("slee/facilities/profiletableactivitycontextinterfacefactory");
            ActivityContextInterface profileTableACI = profileTableACIFactory.getActivityContextInterface(tableActivity);
            try {
                profileTableACI.attach(this.getSbbContext().getSbbLocalObject());
            }
            catch (Exception ex) {
                throw new TCKTestFailureException(939, "Failed to attach to ProfileTableActivity using attach() due to unexpected Exception", ex);
            }
            this.fireTCKSbbEvent(new TCKSbbEventImpl(null), aci, null);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKSbbEvent(TCKSbbEvent event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.getResourceInterface().sendSbbMessage(TCKResourceEventX.class.getName());
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onProfileAddedEvent(ProfileAddedEvent event, ActivityContextInterface aci) {
        try {
            this.checkCMPFields();
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.FINE, "Received ProfileAddedEvent event:" + event, null);
            String expectName = this.getIsFirstProfileAdded() ? this.getSecondProfileName() : this.getFirstProfileName();
            ProfileID expectedProfile = new ProfileID(this.getProfileTableName(), expectName);
            this.validateProfileAddedEvent(event, aci, expectedProfile);
            if (!this.getIsFirstProfileAdded()) {
                this.setIsFirstProfileAdded(true);
            }
            this.checkProfileTableTransaction(event);
            TCKSbbUtils.getResourceInterface().sendSbbMessage(ProfileAddedEvent.class.getName());
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onProfileRemovedEvent(ProfileRemovedEvent event, ActivityContextInterface aci) {
        try {
            this.checkCMPFields();
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.FINE, "Received ProfileRemovedEvent event:" + event, null);
            String expectName = this.getIsFirstProfileRemoved() ? this.getSecondProfileName() : this.getFirstProfileName();
            ProfileID expectedProfile = new ProfileID(this.getProfileTableName(), expectName);
            this.validateProfileRemovedEvent(event, aci, expectedProfile);
            if (!this.getIsFirstProfileRemoved()) {
                this.setIsFirstProfileRemoved(true);
            }
            this.checkProfileTableTransaction(event);
            TCKSbbUtils.getResourceInterface().sendSbbMessage(ProfileRemovedEvent.class.getName());
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onProfileUpdatedEvent(ProfileUpdatedEvent event, ActivityContextInterface aci) {
        try {
            this.checkCMPFields();
            TCKSbbUtils.createTrace((ComponentID)this.getSbbID(), Level.FINE, "Received ProfileUpdatedEvent event", null);
            Address address = event.getProfileAddress();
            Assert.assertTrue(922, "The address plan of a ProfileUpdatedEvent should be AddressPlan.SLEE_PROFILE", address.getAddressPlan().isSleeProfile());
            String expectedAddressString = this.getProfileTableName() + "/" + this.getSecondProfileName();
            Assert.assertEquals(922, "The address string of a ProfileUpdatedEvent should be Profile identifier encoded as profile_table_name/profile_name", expectedAddressString, address.getAddressString());
            ProfileID expectedProfile = new ProfileID(this.getProfileTableName(), this.getSecondProfileName());
            Assert.assertEquals(960, "ProfileUpdatedEvent.getProfile() should return the ID of the profile added to the table", expectedProfile, event.getProfile());
            Object activity = aci.getActivity();
            if (activity == null || !(activity instanceof ProfileTableActivity)) {
                throw new TCKTestFailureException(940, "ProfileUpdatedEvents must be fired on a ProfileTableActivity");
            }
            ProfileTableActivity profileTableActivity = (ProfileTableActivity)activity;
            Assert.assertEquals(2409, "A ProfileUpdatedEvent was fired on on the wrong ProfileTableActivity (the profile table names did not match).", this.getProfileTableName(), profileTableActivity.getProfileTableName());
            this.checkProfileTableTransaction(event);
            TCKSbbUtils.getResourceInterface().sendSbbMessage(ProfileUpdatedEvent.class.getName());
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public abstract void fireTCKSbbEvent(TCKSbbEvent var1, ActivityContextInterface var2, Address var3);

    private void validateProfileAddedEvent(ProfileAddedEvent event, ActivityContextInterface aci, ProfileID expectedProfile) throws TCKTestFailureException {
        Address address = event.getProfileAddress();
        Assert.assertTrue(922, "The address plan of a ProfileAddedEvent should be AddressPlan.SLEE_PROFILE", address.getAddressPlan().isSleeProfile());
        String expectedAddressString = expectedProfile.getProfileTableName() + "/" + expectedProfile.getProfileName();
        Assert.assertEquals(922, "The address string of a ProfileAddedEvent should be Profile identifier encoded as profile_table_name/profile_name", expectedAddressString, address.getAddressString());
        Assert.assertEquals(946, "getProfile() should return the ID of the profile added to the table", expectedProfile, event.getProfile());
        Object activity = aci.getActivity();
        if (activity == null || !(activity instanceof ProfileTableActivity)) {
            throw new TCKTestFailureException(940, "ProfileAddedEvents must be fired on a ProfileTableActivity");
        }
        ProfileTableActivity profileTableActivity = (ProfileTableActivity)activity;
        Assert.assertEquals(935, "A ProfileAddedEvent was fired on on the wrong ProfileTableActivity (the profile table names did not match).", this.getProfileTableName(), profileTableActivity.getProfileTableName());
    }

    private void validateProfileRemovedEvent(ProfileRemovedEvent event, ActivityContextInterface aci, ProfileID expectedProfile) throws TCKTestFailureException {
        Address address = event.getProfileAddress();
        Assert.assertTrue(922, "The address plan of a ProfileRemovedEvent should be AddressPlan.SLEE_PROFILE", address.getAddressPlan().isSleeProfile());
        String expectedAddressString = expectedProfile.getProfileTableName() + "/" + expectedProfile.getProfileName();
        Assert.assertEquals(922, "The address string of a ProfileRemovedEvent should be Profile identifier encoded as profile_table_name/profile_name", expectedAddressString, address.getAddressString());
        Assert.assertEquals(948, "getProfile() should return the ID of the profile removed from the table", expectedProfile, event.getProfile());
        Object activity = aci.getActivity();
        if (activity == null || !(activity instanceof ProfileTableActivity)) {
            throw new TCKTestFailureException(940, "ProfileRemovedEvents must be fired on a ProfileTableActivity");
        }
        ProfileTableActivity profileTableActivity = (ProfileTableActivity)activity;
        Assert.assertEquals(936, "A ProfileRemovedEvent was fired on on the wrong ProfileTableActivity (the profile table names did not match).", this.getProfileTableName(), profileTableActivity.getProfileTableName());
    }

    private void checkProfileTableTransaction(Object event) throws TCKTestFailureException {
        try {
            this.getSbbContext().getRollbackOnly();
        }
        catch (TransactionRequiredLocalException trle) {
            throw new TCKTestFailureException(938, "A profile table event was invoked without a valid transaction context: getRollbackOnly() threw a TransactionRequiredLocalException. event=" + event, (Exception)((Object)trle));
        }
    }

    private void checkCMPFields() throws TCKTestErrorException {
        if (this.getProfileTableName() == null || this.getFirstProfileName() == null || this.getSecondProfileName() == null) {
            throw new TCKTestErrorException("ProfileEventsTestSbb: The CMP fields must be set to non null values before receiving profile and profile table events.");
        }
    }

    public abstract String getProfileTableName();

    public abstract void setProfileTableName(String var1);

    public abstract String getFirstProfileName();

    public abstract void setFirstProfileName(String var1);

    public abstract String getSecondProfileName();

    public abstract void setSecondProfileName(String var1);

    public abstract boolean getIsFirstProfileAdded();

    public abstract void setIsFirstProfileAdded(boolean var1);

    public abstract boolean getIsFirstProfileRemoved();

    public abstract void setIsFirstProfileRemoved(boolean var1);

    public abstract SimpleProfileCMP getProfileCMP(ProfileID var1) throws UnrecognizedProfileTableNameException, UnrecognizedProfileNameException;
}

