/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.lifecycle;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testsuite.profiles.lifecycle.Test1110227ProfileCMP;
import java.util.HashMap;
import javax.slee.CreateException;
import javax.slee.profile.Profile;
import javax.slee.profile.ProfileContext;
import javax.slee.profile.ProfileVerificationException;

public abstract class Test1110227Profile
implements Test1110227ProfileCMP,
Profile {
    public static final int setProfileContextCalledAfterConstructor = 1110234;
    public static final int setProfileContextNoCMPAccess = 1110236;
    public static final int unsetProfileContextNoCMPAccess = 1110240;
    public static final int profileInitializeCMPDefaultValues = 1110245;
    public static final int profileRemoveCalledBeforeRemoveCMP = 1110261;
    public static final int profileRemoveStillInReadyState = 1110263;
    public static final int profileVerifyCalled = 1110276;
    public static final int profileVerifyInReadyState = 1110278;
    public static final int profileVerifyAfterStore = 1110280;
    public static final int profileVerifyTXNContext = 1110280;
    public static final int profileVerifyOnlyCalledForManagement = 1110281;
    public static final int profileVerifyNotOnDefaultProfile = 1110282;
    public static final int profileInitCalledInPooledState = 0x10F111;
    public static final int profilePostCreateCalledInPooledState = 0x10F111;
    public static final int profileInitCalledForDefaultProfile = 1110290;
    public static final int businessMethodCalledInReadyState = 1110294;
    public static final int profileLoadCalledInReadyState = 1110294;
    public static final int profileStoreCalledInReadyState = 1110294;
    public static final int profileObjectAssocOneTable = 1110304;
    public static final int profilePassivateNoCMPAccess = 1110259;
    public static final int passivateCalledAfterStore = 1110296;
    public static final int passivateCalledInReadyState = 1110296;
    public static final int profileActivateNoCMPAccess = 1110255;
    public static final int activateCalledInPooledState = 1110293;
    public static final int notPreceededByInitializeCantBeDefaultProfile = 1110291;
    public static final int unsetProfileContextCalledInPooledState = 1110698;
    private ProfileContext context;
    private int stateTrace;
    private int methodTrace;
    public static final int INVALID = -1;
    public static final int AFTER_CONSTRUCTOR = 1;
    public static final int AFTER_SET_CONTEXT = 2;
    public static final int AFTER_PROFILE_INIT = 4;
    public static final int AFTER_POST_CREATE = 5;
    public static final int AFTER_ACTIVATE = 6;
    public static final int AFTER_LOAD = 7;
    public static final int AFTER_VERIFY = 8;
    public static final int AFTER_STORE = 9;
    public static final int AFTER_PASSIVATE = 10;
    public static final int AFTER_REMOVE = 11;
    public static final int AFTER_UNSET_CONTEXT = 12;
    public static final int DOESNTEXIST = 0;
    public static final int POOLED = 14;
    public static final int READY = 15;
    private RMIObjectChannel out;
    private BaseMessageSender msgSender;
    private String profileTableName;

    public Test1110227Profile() {
        StdErrLog log = new StdErrLog();
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, log);
        }
        catch (Exception e) {
            log.error("An error occured creating an RMIObjectChannel:");
            log.error(e);
        }
        this.profileTableName = null;
        this.methodTrace = 1;
        this.stateTrace = 1;
    }

    public void setProfileContext(ProfileContext context) {
        context.getTracer("setProfileContext").info("setProfileContext called");
        if (this.methodTrace != 1) {
            this.methodTrace = -1;
            this.msgSender.sendFailure(1110234, "'SetProfileContext()' was not correctly called immediately after constructor call.");
            return;
        }
        this.msgSender.sendSuccess(1110234, "'SetProfileContext()' was correctly called immediately after constructor call.");
        this.methodTrace = 2;
        this.stateTrace = 14;
        try {
            this.getValue();
            this.msgSender.sendFailure(1110236, "Calling 'getValue()' within 'setProfileContext' succeeded but should have caused an exception.");
        }
        catch (IllegalStateException e) {
            this.msgSender.sendSuccess(1110236, "setProfileContext(): Caught exception as expected: " + e);
        }
        catch (Exception e) {
            this.msgSender.sendFailure(1110236, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.IllegalStateException");
        }
        this.context = context;
        this.profileTableName = context.getProfileTableName();
    }

    public void unsetProfileContext() {
        this.context.getTracer("unsetProfileContext").info("unsetProfileContext called");
        if (this.stateTrace == 14) {
            this.msgSender.sendSuccess(1110698, "'unsetProfileContext': Called in Pooled state.");
        } else {
            this.msgSender.sendFailure(1110698, "'unsetProfileContext': Not called in Pooled state.");
        }
        if (!this.profileTableName.equals(this.context.getProfileTableName())) {
            this.msgSender.sendFailure(1110304, "Varying profile table name found. A profile object may only be associated with one and the same profile table during its lifetime.");
        }
        try {
            this.getValue();
            this.msgSender.sendFailure(1110240, "Calling 'getValue()' within 'unsetProfileContext' succeeded but should have caused an exception.");
        }
        catch (IllegalStateException e) {
            this.msgSender.sendSuccess(1110240, "unsetProfileContext(): Caught exception as expected: " + e);
        }
        catch (Exception e) {
            this.msgSender.sendFailure(1110240, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.IllegalStateException");
        }
        this.context = null;
        this.methodTrace = 12;
        this.stateTrace = 0;
    }

    public void profileInitialize() {
        this.context.getTracer("profileInitialize").info("profileInitialize called");
        if (!this.profileTableName.equals(this.context.getProfileTableName())) {
            this.msgSender.sendFailure(1110304, "Varying profile table name found. A profile object may only be associated with one and the same profile table during its lifetime.");
        }
        if (this.stateTrace == 14) {
            this.msgSender.sendSuccess(0x10F111, "'profileInitialize': Called in Pooled state.");
        } else {
            this.msgSender.sendFailure(0x10F111, "'profileInitialize': Not called in Pooled state.");
        }
        int std_int = this.getValue();
        long std_long = this.getLongValue();
        boolean std_bool = this.getBoolValue();
        String std_Str = this.getStringValue();
        HashMap std_obj = this.getObjValue();
        if (std_int == 0 && std_long == 0L && !std_bool && std_Str == null && std_obj == null) {
            this.msgSender.sendSuccess(1110245, "'profileInitialize': CMP get methods initially returned Java language defaults as expected.");
        } else {
            this.msgSender.sendFailure(1110245, "'profileInitialize': CMP get methods did NOT initially return Java language defaults.");
        }
        this.setValue(2);
        this.setValue2(8);
        this.setStringValue("Init");
        try {
            this.context.getProfileName();
            this.msgSender.sendFailure(1110290, "profileInitialize may only be called for a profile table's default profile.");
        }
        catch (Exception e) {
            this.msgSender.sendSuccess(1110290, "profileInitialize has been called for a profile table's default profile.");
        }
        this.methodTrace = 4;
        this.stateTrace = 4;
    }

    public void profilePostCreate() throws CreateException {
        this.context.getTracer("profilePostCreate").info("profilePostCreate called");
        if (!this.profileTableName.equals(this.context.getProfileTableName())) {
            this.msgSender.sendFailure(1110304, "Varying profile table name found. A profile object may only be associated with one and the same profile table during its lifetime.");
        }
        if (this.stateTrace == 14 || this.stateTrace == 4) {
            this.msgSender.sendSuccess(0x10F111, "'profilePostCreate': Called in Pooled state or directly after profileInitialize.");
        } else {
            this.msgSender.sendFailure(0x10F111, "'profilePostCreate': Not called in Pooled state or directly after profileInitialize.");
        }
        if (this.methodTrace != 4 && this.context.getProfileName() == null) {
            this.msgSender.sendFailure(1110291, "If profilePostCreate has not been preceeded by a call to profileInitialize the associated profile can't be a profile table's default profile.");
        }
        this.methodTrace = 5;
        this.stateTrace = 15;
    }

    public void profileActivate() {
        this.context.getTracer("profileActivate").info("profileActivate called");
        if (!this.profileTableName.equals(this.context.getProfileTableName())) {
            this.msgSender.sendFailure(1110304, "Varying profile table name found. A profile object may only be associated with one and the same profile table during its lifetime.");
        }
        if (this.stateTrace == 14) {
            this.msgSender.sendSuccess(1110293, "'profileActivate': Called in Pooled state.");
        } else {
            this.msgSender.sendFailure(1110293, "'profileActivate': Not called in Pooled state.");
        }
        try {
            this.getValue();
            this.msgSender.sendFailure(1110255, "Calling 'getValue()' within 'profileActivate' succeeded but should have caused an exception.");
        }
        catch (IllegalStateException e) {
            this.msgSender.sendSuccess(1110255, "profileActivate(): Caught exception as expected: " + e);
        }
        catch (Exception e) {
            this.msgSender.sendFailure(1110255, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.IllegalStateException");
        }
        this.methodTrace = 6;
        this.stateTrace = 15;
    }

    public void profilePassivate() {
        this.context.getTracer("profilePassivate").info("profilePassivate called");
        if (!this.profileTableName.equals(this.context.getProfileTableName())) {
            this.msgSender.sendFailure(1110304, "Varying profile table name found. A profile object may only be associated with one and the same profile table during its lifetime.");
        }
        if (this.stateTrace == 15) {
            this.msgSender.sendSuccess(1110296, "'profilePassivate': Called in READY state.");
        } else {
            this.msgSender.sendFailure(1110296, "'profilePassivate': Not called in READY state.");
        }
        if (this.methodTrace == 9) {
            this.msgSender.sendSuccess(1110296, "'profilePassivate' has correctly been preceeded by a call to profileStore.");
        } else {
            this.msgSender.sendFailure(1110296, "'profilePassivate' should have been preceeded by a call to profileStore.");
        }
        try {
            this.getValue();
            this.msgSender.sendFailure(1110259, "Calling 'getValue()' within 'profilePassivate' succeeded but should have caused an exception.");
        }
        catch (IllegalStateException e) {
            this.msgSender.sendSuccess(1110259, "profilePassivate(): Caught exception as expected: " + e);
        }
        catch (Exception e) {
            this.msgSender.sendFailure(1110259, "Wrong type of exception thrown: " + e.getClass().getName() + " Expected: java.lang.IllegalStateException");
        }
        this.methodTrace = 10;
        this.stateTrace = 14;
    }

    public void profileLoad() {
        this.context.getTracer("profileLoad").info("profileLoad called");
        if (!this.profileTableName.equals(this.context.getProfileTableName())) {
            this.msgSender.sendFailure(1110304, "Varying profile table name found. A profile object may only be associated with one and the same profile table during its lifetime.");
        }
        if (this.stateTrace == 15) {
            this.msgSender.sendSuccess(1110294, "'profileLoad': Called in Ready state.");
        } else {
            this.msgSender.sendFailure(1110294, "'profileLoad': Not called in Ready state.");
        }
        this.methodTrace = 7;
        this.stateTrace = 15;
    }

    public void profileStore() {
        this.context.getTracer("profileStore").info("profileStore called");
        if (!this.profileTableName.equals(this.context.getProfileTableName())) {
            this.msgSender.sendFailure(1110304, "Varying profile table name found. A profile object may only be associated with one and the same profile table during its lifetime.");
        }
        if (this.stateTrace == 15) {
            this.msgSender.sendSuccess(1110294, "'profileStore': Called in Ready state.");
        } else {
            this.msgSender.sendFailure(1110294, "'profileStore': Not called in Ready state.");
        }
        this.methodTrace = 9;
        this.stateTrace = 15;
    }

    public void profileRemove() {
        this.context.getTracer("profileRemove").info("profileRemove called");
        if (!this.profileTableName.equals(this.context.getProfileTableName())) {
            this.msgSender.sendFailure(1110304, "Varying profile table name found. A profile object may only be associated with one and the same profile table during its lifetime.");
        }
        if (this.getValue() == 2 && this.getValue2() == 8) {
            this.msgSender.sendSuccess(1110261, "'profileRemove()' was correctly called before the profile which the profile object was assigned to was removed.");
        } else {
            this.msgSender.sendFailure(1110261, "'profileRemove()': the profile that this profile objects was assigned to should be removed AFTER this method completed, thus the CMP accessors should still have been accessible at this stage.");
        }
        if (this.stateTrace == 15) {
            this.msgSender.sendSuccess(1110263, "profileRemove was called on profile object in READY state.");
        } else {
            this.msgSender.sendFailure(1110263, "profileRemove may only be called on profile object in READY state.");
        }
        this.methodTrace = 11;
        this.stateTrace = 14;
    }

    public void profileVerify() throws ProfileVerificationException {
        this.context.getTracer("profileVerify").info("profileVerify called");
        if (!this.profileTableName.equals(this.context.getProfileTableName())) {
            this.msgSender.sendFailure(1110304, "Varying profile table name found. A profile object may only be associated with one and the same profile table during its lifetime.");
        }
        this.msgSender.sendSuccess(1110276, "profileVerify has been called.");
        if (this.stateTrace == 15) {
            this.msgSender.sendSuccess(1110278, "profileVerify was called on profile object in READY state.");
        } else {
            this.msgSender.sendFailure(1110278, "profileVerify may only be called on profile object in READY state.");
        }
        if (this.methodTrace == 9) {
            this.msgSender.sendSuccess(1110280, "profileVerify was called after profileStore.");
        } else {
            this.msgSender.sendFailure(1110280, "profileVerify() should have been called after a call to profileStore().");
        }
        if (this.getStringValue().equals("Rollback")) {
            this.setStringValue("Modified");
            this.context.setRollbackOnly();
        }
        this.methodTrace = 8;
        this.stateTrace = 15;
    }

    public boolean business() {
        this.context.getTracer("business").fine("Business method called.");
        if (!this.profileTableName.equals(this.context.getProfileTableName())) {
            this.msgSender.sendFailure(1110304, "Varying profile table name found. A profile object may only be associated with one and the same profile table during its lifetime.");
        }
        if (this.stateTrace == 15) {
            this.msgSender.sendSuccess(1110294, "Business method called in Ready state.");
        } else {
            this.msgSender.sendFailure(1110294, "Business method not called in Ready state.");
        }
        return this.getValue() == 2 && this.getValue2() == 8;
    }
}

