/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.lifecycle;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.testsuite.profiles.lifecycle.Test1110227ProfileLocal;
import javax.naming.Context;
import javax.slee.ActivityContextInterface;
import javax.slee.SbbContext;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileTable;

public abstract class Test1110227Sbb
extends BaseTCKSbb {
    public static final String PROFILE_TABLE_NAME = "Test1110227ProfileTable";
    public static final String PROFILE_NAME = "Test1110227Profile";
    public static final String PROFILE_NAME2 = "Test1110227Profile2";
    public static final String PROFILE_NAME3 = "Test1110227Profile3";
    public static final String INIT = "Init";
    public static final String ROLLBACK = "Rollback";
    public static final String MODIFIED = "Modified";
    private RMIObjectChannel out;
    private BaseMessageSender msgSender;

    public void setSbbContext(SbbContext context) {
        super.setSbbContext(context);
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, new StdErrLog());
        }
        catch (Exception e) {
            context.getTracer(this.getSbbID().getName()).fine("An error occured creating an RMIObjectChannel:", (Throwable)e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            Context env = TCKSbbUtils.getSbbEnvironment();
            ProfileFacility profileFacility = (ProfileFacility)env.lookup("slee/facilities/profile");
            this.msgSender.sendLogMsg("Obtained profileFacility object.");
            ProfileTable profileTable = profileFacility.getProfileTable(PROFILE_TABLE_NAME);
            this.msgSender.sendLogMsg("Obtained profileTable object.");
            this.msgSender.sendLogMsg("Set CMP value so that profileVerify would cause rollback if it was called by the SLEE.");
            Test1110227ProfileLocal profileLocal = (Test1110227ProfileLocal)profileTable.find(PROFILE_NAME);
            profileLocal.setStringValue(ROLLBACK);
            profileLocal.business();
            Test1110227ProfileLocal profileLocal2 = (Test1110227ProfileLocal)profileTable.create(PROFILE_NAME2);
            profileLocal2.setStringValue(ROLLBACK);
            profileLocal2.business();
            if (this.getSbbContext().getRollbackOnly()) {
                this.msgSender.sendFailure(1110281, "Call to profileVerify occured but should not have happened.");
            } else {
                this.msgSender.sendSuccess(1110281, "As expected call to profileVerify did not occur.");
            }
        }
        catch (Exception e) {
            this.msgSender.sendException(e);
        }
    }
}

