/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.lifecycle;

import com.opencloud.logging.StdErrLog;
import com.opencloud.sleetck.lib.profileutils.BaseMessageSender;
import com.opencloud.sleetck.lib.rautils.RMIObjectChannel;
import com.opencloud.sleetck.lib.rautils.TCKRAUtils;
import com.opencloud.sleetck.lib.testsuite.profiles.lifecycle.Test1110305ProfileCMP;
import com.opencloud.sleetck.lib.testsuite.profiles.lifecycle.Test1110305ProfileManagement;
import javax.slee.CreateException;
import javax.slee.profile.Profile;
import javax.slee.profile.ProfileContext;
import javax.slee.profile.ProfileVerificationException;

public abstract class Test1110305Profile
implements Test1110305ProfileCMP,
Profile,
Test1110305ProfileManagement {
    public static final String THROW_EXCEPTION = "ThrowException";
    public static final String INIT = "Init";
    private ProfileContext context;
    private RMIObjectChannel out;
    private BaseMessageSender msgSender;
    private boolean objectIsInvalid;

    public Test1110305Profile() {
        StdErrLog log = new StdErrLog();
        try {
            this.out = TCKRAUtils.lookupRMIObjectChannel();
            this.msgSender = new BaseMessageSender(this.out, log);
        }
        catch (Exception e) {
            log.error("An error occured creating an RMIObjectChannel:");
            log.error(e);
        }
        this.objectIsInvalid = false;
    }

    public void setProfileContext(ProfileContext context) {
        context.getTracer("setProfileContext").info("setProfileContext called");
        this.context = context;
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'setProfileContext' was called on profile object after RuntimeException occurred.");
        }
    }

    public void unsetProfileContext() {
        this.context.getTracer("unsetProfileContext").info("unsetProfileContext called");
        this.context = null;
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'unsetProfileContext' was called on profile object after RuntimeException occurred.");
        }
    }

    public void profileInitialize() {
        this.context.getTracer("profileInitialize").info("profileInitialize called");
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'profileInitialize' was called on profile object after RuntimeException occurred.");
        }
    }

    public void profilePostCreate() throws CreateException {
        this.context.getTracer("profilePostCreate").info("profilePostCreate called");
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'profilePostCreate' was called on profile object after RuntimeException occurred.");
        }
    }

    public void profileActivate() {
        this.context.getTracer("profileActivate").info("profileActivate called");
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'profileActivate' was called on profile object after RuntimeException occurred.");
        }
    }

    public void profilePassivate() {
        this.context.getTracer("profilePassivate").info("profilePassivate called");
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'profilePassivate' was called on profile object after RuntimeException occurred.");
        }
    }

    public void profileLoad() {
        this.context.getTracer("profileLoad").info("profileLoad called");
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'profileLoad' was called on profile object after RuntimeException occurred.");
        }
    }

    public void profileStore() {
        this.context.getTracer("profileStore").info("profileStore called");
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'profileStore' was called on profile object after RuntimeException occurred.");
        }
    }

    public void profileRemove() {
        this.context.getTracer("profileRemove").info("profileRemove called");
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'profileRemove' was called on profile object after RuntimeException occurred.");
        }
    }

    public void profileVerify() throws ProfileVerificationException {
        this.context.getTracer("profileVerify").info("profileVerify called");
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'profileVerify' was called on profile object after RuntimeException occurred.");
        }
        if (this.context.getProfileName().equals("LifecycleProfile") && this.getValue().equals(THROW_EXCEPTION)) {
            this.objectIsInvalid = true;
            throw new RuntimeException("Testexception.");
        }
    }

    public void business() {
        this.context.getTracer("business").fine("Business method called.");
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'business' was called on profile object after RuntimeException occurred.");
        }
        if (this.context.getProfileName().equals("BusinessProfile") && this.getValue().equals(THROW_EXCEPTION)) {
            this.objectIsInvalid = true;
            throw new RuntimeException("Testexception.");
        }
    }

    public void manage() {
        this.context.getTracer("manage").fine("Management method called.");
        if (this.objectIsInvalid) {
            this.msgSender.sendFailure(1110306, "'manage' was called on profile object after RuntimeException occurred.");
        }
        if (this.context.getProfileName().equals("ManagementProfile") && this.getValue().equals(THROW_EXCEPTION)) {
            this.objectIsInvalid = true;
            throw new RuntimeException("Testexception.");
        }
    }
}

