/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileabstractclass;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.QueuingResourceListener;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;
import javax.slee.profile.ProfileVerificationException;
import javax.slee.profile.UnrecognizedProfileNameException;

public class Test1110251Test
extends AbstractSleeTCKTest {
    private static final String DU_PATH_PARAM = "DUPath";
    private static final String SPEC_NAME = "Test1110251Profile";
    private static final String SPEC_VERSION = "1.0";
    private ProfileUtils profileUtils;
    private QueuingResourceListener resourceListener;
    private ProfileProvisioningMBeanProxy profileProvisioning;

    public TCKTestResult run() throws Exception {
        ProfileSpecificationID specID = new ProfileSpecificationID(SPEC_NAME, "jain.slee.tck", SPEC_VERSION);
        this.profileProvisioning.createProfileTable(specID, "Test1110251ProfileTable");
        this.getLog().fine("Added profile table Test1110251ProfileTable based on profile spec Test1110251Profile");
        this.getLog().fine("Try to create profile Test1110251Profile via management client...");
        try {
            this.profileProvisioning.createProfile("Test1110251ProfileTable", SPEC_NAME);
            return TCKTestResult.failed(1110251, "Create operation through management client succeeded but should have thrown a javax.slee.management.ManagementException exception.");
        }
        catch (ManagementException e) {
            this.getLog().fine("Caught expected exception: javax.slee.management.ManagementException.");
        }
        catch (Exception e) {
            return TCKTestResult.failed(1110251, "Wrong type of exception: " + e.getClass().getName() + " javax.slee.management.ManagementException expected");
        }
        this.getLog().fine("Try to create profile Test1110251Profile via SLEE component...");
        this.sendResourceEvent(1);
        try {
            this.profileProvisioning.getProfile("Test1110251ProfileTable", SPEC_NAME);
            return TCKTestResult.failed(1110251, "Create operation through SBB component succeeded but profile Test1110251Profile should not have been created.");
        }
        catch (UnrecognizedProfileNameException e) {
            this.getLog().fine("Caught expected exception: " + ((Object)((Object)e)).getClass().getName());
        }
        catch (Exception e) {
            return TCKTestResult.failed(1110251, "Wrong type of exception: " + e.getClass().getName() + " javax.slee.profile.UnrecognizedProfileNameException expected");
        }
        this.getLog().fine("Create profile RemoveProfile");
        ObjectName profile = this.profileProvisioning.createProfile("Test1110251ProfileTable", "RemoveProfile");
        ProfileMBeanProxy profileProxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        profileProxy.commitProfile();
        profileProxy.closeProfile();
        this.getLog().fine("Try to remove profile RemoveProfile via management client...");
        try {
            this.profileProvisioning.removeProfile("Test1110251ProfileTable", "RemoveProfile");
            return TCKTestResult.failed(1110266, "Remove operation through management client succeeded but should have thrown a javax.slee.management.ManagementException exception.");
        }
        catch (ManagementException e) {
            this.getLog().fine("Caught expected exception: javax.slee.management.ManagementException.");
        }
        catch (Exception e) {
            return TCKTestResult.failed(1110266, "Wrong type of exception: " + e.getClass().getName() + " javax.slee.management.ManagementException expected.");
        }
        this.getLog().fine("Try to remove profile RemoveProfile via SLEE component...");
        this.sendResourceEvent(3);
        try {
            this.profileProvisioning.getProfile("Test1110251ProfileTable", "RemoveProfile");
            this.getLog().fine("Profile RemoveProfile still exists after Sbb component's remove operation rolled back.");
        }
        catch (Exception e) {
            return TCKTestResult.failed(1110266, "Remove operation through SBB component succeeded but should have failed.");
        }
        this.getLog().fine("Create profile StoreProfile");
        ObjectName profile2 = this.profileProvisioning.createProfile("Test1110251ProfileTable", "StoreProfile");
        ProfileMBeanProxy profileProxy2 = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile2);
        try {
            this.getLog().fine("Set 'value' CMP field to 'Rollback'");
            this.utils().getMBeanFacade().setAttribute(profile2, new Attribute("Value", "Rollback"));
            profileProxy2.commitProfile();
            profileProxy2.closeProfile();
            this.getLog().fine("Try to cause SLEE call to profileStore method for profile StoreProfile via management client...");
            this.profileProvisioning.removeProfile("Test1110251ProfileTable", "StoreProfile");
            return TCKTestResult.failed(1110275, "Remove operation through management client succeeded but should have thrown a javax.slee.management.ManagementException exception.");
        }
        catch (ManagementException e) {
            this.getLog().fine("Caught expected exception: javax.slee.management.ManagementException.");
        }
        catch (Exception e) {
            this.getLog().fine("Caught wrong type of exception.");
            return TCKTestResult.failed(1110275, "Wrong type of exception: " + e.getClass().getName() + " javax.slee.management.ManagementException expected.");
        }
        this.getLog().fine("Create profile VerifyExceptionProfile");
        ObjectName profile3 = this.profileProvisioning.createProfile("Test1110251ProfileTable", "VerifyExceptionProfile");
        ProfileMBeanProxy profileProxy3 = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile3);
        try {
            profileProxy3.commitProfile();
            profileProxy3.closeProfile();
            return TCKTestResult.failed(1110279, "Commit succeeded but should have thrown an exception as profileVerify has been configured to throw a ProfileVerificationException.");
        }
        catch (ProfileVerificationException e) {
            this.getLog().fine("Caught expected exception: " + (Object)((Object)e));
        }
        catch (Exception e) {
            return TCKTestResult.failed(1110279, "Wrong type of exception: " + e.getClass().getName() + " javax.slee.profile.ProfileVerificationException expected.");
        }
        return TCKTestResult.passed();
    }

    private void sendResourceEvent(int operationID) throws TCKTestErrorException, RemoteException, TCKTestFailureException {
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(this.getClass().getName());
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", new Integer(operationID), activityID, null);
        try {
            TCKSbbMessage reply = this.resourceListener.nextMessage();
            HashMap map = (HashMap)reply.getMessage();
            int type = (Integer)map.get("Type");
            String msg = (String)map.get("Msg");
            int id = (Integer)map.get("ID");
            boolean result = (Boolean)map.get("Result");
            switch (type) {
                case 0: {
                    if (result) {
                        this.getLog().fine(id + ": " + msg);
                        break;
                    }
                    this.getLog().fine("FAILURE: " + msg);
                    throw new TCKTestFailureException(id, msg);
                }
            }
        }
        catch (OperationTimedOutException ex) {
            throw new TCKTestErrorException("Timed out waiting for processing of initial resource event.", ex);
        }
    }

    public void setUp() throws Exception {
        this.setupService(DU_PATH_PARAM);
        this.profileUtils = new ProfileUtils(this.utils());
        this.profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        this.resourceListener = new QueuingResourceListener(this.utils()){

            public Object onSbbCall(Object argument) throws Exception {
                HashMap map = (HashMap)argument;
                int type = (Integer)map.get("Type");
                switch (type) {
                    case 1: {
                        Test1110251Test.this.getLog().fine((String)map.get("Msg"));
                    }
                }
                return null;
            }
        };
        this.setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        try {
            this.profileUtils.removeProfileTable("Test1110251ProfileTable");
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

