/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileadded;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.sbbutils.events2.SbbMessageAdapter;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.slee.profile.ProfileSpecificationID;

public class Test1110016Test
extends AbstractSleeTCKTest {
    private static final String TCK_SBB_EVENT_DU_PATH_PARAM = "eventDUPath";
    private static final String SEND_RESULT_EVENT_DU_PATH_PARAM = "resultEventDUPath";
    private static final String PROFILE_TABLE_NAME = "Test1110016ProfileTable";
    private static final String PROFILE_NAME = "Test1110016Profile";
    private static final int TEST_ID = 0x10F000;
    private static final String PROFILE_SPEC_NAME = "ProfileEventsTestsProfile";
    private static final String PROFILE_SPEC_VERSION = "1.0";
    private FutureResult result;
    private ProfileProvisioningMBeanProxy profileProvisioning;

    public TCKTestResult run() throws Exception {
        Logable log = this.utils().getLog();
        this.result = new FutureResult(this.utils().getLog());
        ProfileSpecificationID profSpecID = new ProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", PROFILE_SPEC_VERSION);
        this.profileProvisioning.createProfileTable(profSpecID, PROFILE_TABLE_NAME);
        log.fine("Created profile table Test1110016ProfileTable for profile specification " + profSpecID.getName() + " " + profSpecID.getVersion() + ", " + profSpecID.getVendor());
        ObjectName profile = this.profileProvisioning.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        ProfileMBeanProxy proxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        log.fine("Created profile Test1110016Profile for profile table Test1110016ProfileTable");
        this.utils().getMBeanFacade().setAttribute(profile, new Attribute("Value", new Integer(42)));
        log.fine("Set 'value' to '42'");
        proxy.commitProfile();
        proxy.closeProfile();
        log.fine("Committed and closed profile.");
        log.info("Waiting for Sbb's response to 'ProfileAddedEvent'");
        return this.result.waitForResultOrFail(this.utils().getTestTimeout(), "Timeout waiting for test result", 0x10F000);
    }

    private void onUpdateProfileRequest(Integer newValue) throws Exception {
        Logable log = this.utils().getLog();
        ObjectName profile = this.profileProvisioning.getProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        ProfileMBeanProxy proxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        log.fine("Obtained MBean proxy for profile Test1110016ProfileTable/Test1110016Profile");
        proxy.editProfile();
        this.utils().getMBeanFacade().setAttribute(profile, new Attribute("Value", newValue));
        log.fine("Set 'value' to '" + newValue + "'");
        proxy.commitProfile();
        proxy.closeProfile();
        log.fine("Commit changed value");
    }

    public void setPassed() {
        this.result.setPassed();
    }

    public void setFailed(int id, String msg) {
        this.result.setFailed(id, msg);
    }

    public void setError(Exception e) {
        this.result.setError(e);
    }

    public void setUp() throws Exception {
        this.setupService(TCK_SBB_EVENT_DU_PATH_PARAM);
        this.setupService(SEND_RESULT_EVENT_DU_PATH_PARAM);
        this.setupService("profileSpecDUPath");
        this.setupService("serviceDUPath");
        this.profileProvisioning = new ProfileUtils(this.utils()).getProfileProvisioningProxy();
        this.setResourceListener(new SbbMessageAdapter(){

            public Logable getLog() {
                return Test1110016Test.this.utils().getLog();
            }

            public void onSetPassed(int id, String msg) {
                Test1110016Test.this.setPassed();
            }

            public void onSetFailed(int id, String msg) {
                Test1110016Test.this.setFailed(id, msg);
            }

            public void onSetException(Exception e) {
                Test1110016Test.this.setError(e);
            }

            public void onHandleRequest(int type, HashMap msgLoad) throws Exception {
                switch (type) {
                    case 1024: {
                        Integer id = (Integer)msgLoad.get("ID");
                        Integer newValue = (Integer)msgLoad.get("NewValue");
                        Test1110016Test.this.onUpdateProfileRequest(newValue);
                    }
                }
            }
        });
    }

    public void tearDown() throws Exception {
        try {
            this.profileProvisioning.removeProfileTable(PROFILE_TABLE_NAME);
        }
        catch (Exception e) {
            this.getLog().warning("Exception occured while trying to remove profile table: ");
            this.getLog().warning(e);
        }
        super.tearDown();
    }
}

