/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profilespec;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.BaseTCKSbb;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.sbbutils.events2.SbbBaseMessageComposer;
import com.opencloud.sleetck.lib.sbbutils.events2.SendResultEvent;
import com.opencloud.sleetck.lib.testsuite.profiles.profilespec.ProfileSpecTestsProfileCMP;
import java.util.HashMap;
import javax.naming.Context;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileTable;

public abstract class Test1110051Sbb
extends BaseTCKSbb {
    public static final String PROFILE_TABLE_NAME = "Test1110051ProfileTable";
    public static final String PROFILE_NAME = "Test1110051Profile";

    private void sendLogMsgCall(String msg) {
        HashMap map = SbbBaseMessageComposer.getLogMsg(msg);
        try {
            TCKSbbUtils.getResourceInterface().callTest(map);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    private void sendResult(boolean result, int id, String msg, ActivityContextInterface aci) {
        HashMap map = SbbBaseMessageComposer.getSetResultMsg(result, id, msg);
        this.setResult(map);
        this.fireSendResultEvent(new SendResultEvent(), aci, null);
    }

    public void onSendResultEvent(SendResultEvent event, ActivityContextInterface aci) {
        try {
            TCKSbbUtils.getResourceInterface().sendSbbMessage(this.getResult());
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        try {
            this.sendLogMsgCall("Received TCKResourceEventX1.");
            Context env = TCKSbbUtils.getSbbEnvironment();
            ProfileFacility profileFacility = (ProfileFacility)env.lookup("slee/facilities/profile");
            this.sendLogMsgCall("Obtained ProfileFacility from naming context.");
            ProfileTable profileTable = profileFacility.getProfileTable(PROFILE_TABLE_NAME);
            this.sendLogMsgCall("Obtained ProfileTable object through Profile Facility.");
            if (profileTable == null) {
                this.sendResult(false, 1110052, "The SLEE's default ProfileTable interface implementation was found to be invalid. (ProfileFacility.getProfileTable(Test1110051ProfileTable) returned 'null')", aci);
                return;
            }
            this.sendLogMsgCall("Checked that ProfileTable object is valid.");
            ProfileSpecTestsProfileCMP profileCMP = (ProfileSpecTestsProfileCMP)profileTable.find(PROFILE_NAME);
            profileCMP.setValue("newValue");
            this.sendLogMsgCall("Set new value for profile attribute.");
            if (!profileCMP.getValue().equals("newValue")) {
                this.sendResult(false, 1110061, "Failed to use set/get accessor methods properly.", aci);
            }
            this.sendLogMsgCall("Checked that new value has been successfully set and could be obtained by 'get' accessor.");
            this.sendResult(true, 1110052, "Test successful.", aci);
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
    }

    public abstract void fireSendResultEvent(SendResultEvent var1, ActivityContextInterface var2, Address var3);

    public abstract void setResult(HashMap var1);

    public abstract HashMap getResult();
}

