/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.profiles.profileupdate;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.profiles.simpleprofile.SimpleProfileProxy;
import com.opencloud.sleetck.lib.testutils.Assert;
import com.opencloud.sleetck.lib.testutils.ComponentIDLookup;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.management.ManagementException;
import javax.slee.profile.ProfileSpecificationID;

public class ProfileUpdateTest
extends AbstractSleeTCKTest {
    protected static final String PROFILE_TABLE_NAME = "tck.ProfileUpdateTest.table";
    public static final String PROFILE_SPEC_NAME = "SimpleProfile";
    public static final String VALUE_1 = "value1";
    public static final String VALUE_2 = "value2";
    private ProfileUtils profileUtils;
    private boolean tableCreated = false;
    private Vector activeProxies;

    public TCKTestResult run() throws Exception {
        ProfileProvisioningMBeanProxy profileProvisioning = this.profileUtils.getProfileProvisioningProxy();
        ProfileSpecificationID profileSpecID = new ComponentIDLookup(this.utils()).lookupProfileSpecificationID(PROFILE_SPEC_NAME, "jain.slee.tck", "1.0");
        this.getLog().info("Creating profile table: tck.ProfileUpdateTest.table");
        profileProvisioning.createProfileTable(profileSpecID, PROFILE_TABLE_NAME);
        this.tableCreated = true;
        String name = "A";
        this.getLog().info("Creating profile A");
        ObjectName jmxObjectName = profileProvisioning.createProfile(PROFILE_TABLE_NAME, "A");
        SimpleProfileProxy proxy = this.getProfileProxy(jmxObjectName);
        String startValue = proxy.getValue();
        this.getLog().info("INITIAL VALUE: " + startValue);
        proxy.editProfile();
        proxy.setValue(VALUE_1);
        try {
            proxy.editProfile();
        }
        catch (ManagementException e) {
            Assert.fail(4362, "Caught exception, editProfile() should return silently if called when the profile is already in a writable state: " + (Object)((Object)e));
        }
        Assert.assertEquals(4362, "editProfile() should return silently if called when the profile is already in a writable state.  No exception was thrown but the transaction context has changed", proxy.getValue(), VALUE_1);
        Assert.assertEquals(4362, "Profile should be made writable after calling editProfile()", VALUE_1, proxy.getValue());
        proxy.commitProfile();
        proxy.editProfile();
        proxy.setValue(VALUE_2);
        proxy.restoreProfile();
        Assert.assertEquals(4371, "Changes made in previous update of the profile should have been discarded", VALUE_1, proxy.getValue());
        Assert.assertTrue(4373, "Profile should have been restored to read only state by restoreProfile()", !proxy.isProfileWriteable());
        proxy.closeProfile();
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        String duPath = this.utils().getTestParams().getProperty("profileSpecDUPath");
        this.getLog().fine("Installing profile specification");
        this.utils().install(duPath);
        this.profileUtils = new ProfileUtils(this.utils());
        this.activeProxies = new Vector();
    }

    public void tearDown() throws Exception {
        if (this.activeProxies != null) {
            this.getLog().fine("Closing profiles");
            Iterator activeProxiesIter = this.activeProxies.iterator();
            while (activeProxiesIter.hasNext()) {
                SimpleProfileProxy aProxy = (SimpleProfileProxy)activeProxiesIter.next();
                try {
                    if (aProxy == null) continue;
                    if (aProxy.isProfileWriteable()) {
                        aProxy.restoreProfile();
                    }
                    aProxy.closeProfile();
                }
                catch (Exception ex) {
                    this.getLog().warning("Exception caught while trying to close profiles:");
                    this.getLog().warning(ex);
                }
            }
        }
        try {
            if (this.profileUtils != null && this.tableCreated) {
                this.getLog().fine("Removing profile table");
                this.profileUtils.removeProfileTable(PROFILE_TABLE_NAME);
            }
        }
        catch (Exception e) {
            this.getLog().warning("Caught exception while trying to remove profile table:");
            this.getLog().warning(e);
        }
        super.tearDown();
    }

    private SimpleProfileProxy getProfileProxy(ObjectName mbeanName) {
        SimpleProfileProxy rProxy = new SimpleProfileProxy(mbeanName, this.utils().getMBeanFacade());
        this.activeProxies.addElement(rProxy);
        return rProxy;
    }
}

