/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource;

import com.opencloud.sleetck.lib.rautils.TCKRAConstants;
import com.opencloud.sleetck.lib.rautils.UOID;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleActivityContextInterfaceFactory;
import com.opencloud.sleetck.lib.testsuite.resource.SimpleSbbInterface;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.Tracer;

public abstract class BaseResourceSbb
implements Sbb {
    protected Tracer tracer;
    private SbbContext sbbContext;

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        this.tracer = context.getTracer("SimpleSBB");
    }

    public void unsetSbbContext() {
        this.tracer = null;
        this.sbbContext = null;
    }

    protected void detach(ActivityContextInterface aci) {
        aci.detach(this.sbbContext.getSbbLocalObject());
    }

    protected SbbContext getSbbContext() {
        return this.sbbContext;
    }

    protected SimpleSbbInterface getSbbInterface() throws NamingException {
        return (SimpleSbbInterface)this.getSbbEnvironment().lookup(TCKRAConstants.SIMPLE_RESOURCE_ADAPTOR_LOCATION);
    }

    protected SimpleActivityContextInterfaceFactory getACIFactory() throws NamingException {
        return (SimpleActivityContextInterfaceFactory)this.getSbbEnvironment().lookup(TCKRAConstants.SIMPLE_ACI_FACTORY_LOCATION);
    }

    protected Context getSbbEnvironment() throws NamingException {
        InitialContext initCtx = new InitialContext();
        return (Context)initCtx.lookup("java:comp/env");
    }

    protected void sendSbbMessage(UOID sbbUID, int sequenceID, int methodID, HashMap results) {
        try {
            SimpleSbbInterface sbbInterface = this.getSbbInterface();
            sbbInterface.sendSbbMessage(new TCKMessage(sbbUID, sequenceID, methodID, results));
        }
        catch (Exception e) {
            this.tracer.severe("Exception caught while trying to send message from SBB to TCK", (Throwable)e);
        }
    }
}

