/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.resource.endpoint;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.resource.BaseResourceTest;
import com.opencloud.sleetck.lib.testsuite.resource.TCKMessage;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import com.opencloud.util.Future;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitID;

public class Test1115418Test
extends BaseResourceTest {
    private static final int ASSERTION_ID = 1115418;

    public TCKTestResult run() throws Exception {
        int sequenceID = this.nextMessageID();
        CustomResponseListener listener = new CustomResponseListener(sequenceID);
        listener.addExpectedResult("result-ra1");
        listener.addExpectedResult("result-sbb1");
        listener.addExpectedResult("result-sbb2");
        listener.addExpectedResult("result-token");
        this.sendMessage(51, new Integer(1115418), listener, sequenceID);
        this.getLog().info("Checking TCK received result from RA.");
        Object result1 = listener.getResult("result-ra1");
        if (result1 == null) {
            throw new TCKTestErrorException("Did not receive confirmation that RA received message from TCK.");
        }
        this.checkResult(result1, 1115418);
        this.getLog().info("Checking TCK received result from SBB 1.");
        Object result2 = listener.getResult("result-sbb1");
        if (result2 == null) {
            throw new TCKTestErrorException("Did not receive confirmation that SBB 1 event processing took place.");
        }
        this.checkResult(result2, 1115418);
        this.getLog().info("Checking TCK received state marker token from SBB 1.");
        Object result3 = listener.getResult("result-token");
        if (result3 == null) {
            throw new TCKTestErrorException("Did not receive token back from initial event processing.");
        }
        this.checkResult(result3, 1115418);
        this.getLog().info("Checking TCK received result from SBB 2.");
        Object result4 = listener.getResult("result-sbb2");
        if (result4 == null) {
            throw new TCKTestFailureException(1115418, "Event processing for event fired on suspended activity did not occur.");
        }
        this.checkResult(result4, 1115418);
        this.getLog().info("Checking state marker token was received before SBB 2 result.");
        if (listener.getTokenTime() > listener.getSbbTime()) {
            throw new TCKTestFailureException(1115418, "Event processing for second activity occured while event delivery on that activity was suspended.");
        }
        return TCKTestResult.passed();
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            DeploymentMBeanProxy deploymentMBean = this.utils().getDeploymentMBeanProxy();
            ServiceManagementMBeanProxy serviceMBean = this.utils().getServiceManagementMBeanProxy();
            String serviceDUPath = this.utils().getTestParams().getProperty("serviceDUPath2");
            String absolutePath = this.utils().getDeploymentUnitURL(serviceDUPath);
            this.getLog().info("Installing service: " + absolutePath);
            DeployableUnitID serviceDUID = deploymentMBean.install(absolutePath);
            ServiceID serviceID = this.getServiceID(serviceDUID);
            serviceMBean.activate(serviceID);
        }
        catch (Exception e) {
            this.getLog().error(e);
        }
    }

    public void tearDown() throws Exception {
        try {
            DeploymentMBeanProxy deploymentMBean = this.utils().getDeploymentMBeanProxy();
            String relativePath = this.utils().getTestParams().getProperty("serviceDUPath2");
            String serviceDuPath = this.utils().getDeploymentUnitURL(relativePath);
            this.getLog().info("Uninstalling service: " + serviceDuPath);
            DeployableUnitID serviceDUID = deploymentMBean.getDeployableUnit(serviceDuPath);
            ServiceID serviceID = this.getServiceID(serviceDUID);
            this.utils().deactivateService(serviceID);
            deploymentMBean.uninstall(serviceDUID);
        }
        catch (Exception e) {
            this.getLog().error(e);
        }
        super.tearDown();
    }

    protected class CustomResponseListener
    extends BaseResourceTest.MultiResponseListener {
        private long tokenTime;
        private long sbbTime;

        public CustomResponseListener(int sequenceID) {
            super(sequenceID);
            this.tokenTime = 1L;
            this.sbbTime = 0L;
        }

        public boolean handleMessage(Object obj) throws RemoteException {
            Test1115418Test.this.getLog().info("Received message from test component: " + obj);
            if (!(obj instanceof TCKMessage)) {
                Test1115418Test.this.getLog().error("Unhandled message type: " + obj);
                return false;
            }
            TCKMessage message = (TCKMessage)obj;
            if (message.getSequenceID() != this.expectedResponse) {
                return true;
            }
            HashMap results = (HashMap)message.getArgument();
            if (results == null) {
                return true;
            }
            if (results.get("result-token") != null) {
                this.tokenTime = System.currentTimeMillis();
            }
            if (results.get("result-sbb2") != null) {
                this.sbbTime = System.currentTimeMillis();
            }
            Set keys = results.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Future future = this.getFuture(key);
                if (future == null || future.isSet()) continue;
                future.setValue(results.get(key));
            }
            return true;
        }

        public long getTokenTime() {
            return this.tokenTime;
        }

        public long getSbbTime() {
            return this.sbbTime;
        }
    }
}

