/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.abstractclass;

import com.opencloud.sleetck.lib.resource.events.TCKResourceEventX;
import com.opencloud.sleetck.lib.sbbutils.TCKSbbUtils;
import com.opencloud.sleetck.lib.testsuite.sbb.abstractclass.SendResultsSbb;
import javax.slee.ActivityContextInterface;
import javax.slee.RolledBackContext;
import javax.slee.SLEEException;

public abstract class SbbExceptionThrownEventSbb
extends SendResultsSbb {
    private static final String EXCEPTION_MSG = "Exception Test Message for SbbExceptionThrownSbbNonEvent SBB";
    private TCKResourceEventX event;
    private ActivityContextInterface aci;

    public void onTCKResourceEventX1(TCKResourceEventX event, ActivityContextInterface aci) {
        this.event = event;
        this.aci = aci;
        this.setTestValue(3);
        throw new SLEEException(EXCEPTION_MSG, (Throwable)new Exception(EXCEPTION_MSG));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
        try {
            if (exception == null) {
                this.setResultFailed(462, "Exception passed to sbbExceptionThrown is null");
                return;
            }
            if (!exception.getClass().equals(SLEEException.class)) {
                this.setResultFailed(462, "Exception passed to sbbExceptionThrown is a different type to that thrown: " + exception.getClass().getName());
                return;
            }
            if (!exception.getMessage().equals(EXCEPTION_MSG)) {
                this.setResultFailed(462, "Exception passed to sbbExceptionThrown has different message to that originally given: " + exception.getMessage());
                return;
            }
            Throwable nested = ((SLEEException)exception).getCause();
            if (nested == null) {
                this.setResultFailed(462, "Exception passed to sbbExceptionThrown has lost its nested exception");
                return;
            }
            if (!nested.getClass().equals(Exception.class)) {
                this.setResultFailed(462, "Exception passed to sbbExceptionThrown has a different nested exception type to that thrown: " + nested.getClass().getName());
                return;
            }
            if (!nested.getMessage().equals(EXCEPTION_MSG)) {
                this.setResultFailed(462, "Exception passed to sbbExceptionThrown has a nested exception with a different message to that originally given: " + nested.getMessage());
                return;
            }
            if (this.event == null || this.aci == null) {
                this.setResultFailed(457, "sbbExceptionThrown not invoked on sbb object that threw the exception");
                return;
            }
            if (!this.getSbbContext().getRollbackOnly()) {
                this.setResultFailed(457, "Transaction not marked for rollback in sbbExceptionThrown");
                return;
            }
            if (this.getTestValue() != 3) {
                this.setResultFailed(457, "Transactional state set before exception was thrown has changed: possibly not the same transaction");
                return;
            }
            if (!event.equals(this.event)) {
                this.setResultFailed(463, "sbbExceptionThrown does not have the event object from event-handler method that threw the exception");
                return;
            }
            if (!aci.equals(this.aci)) {
                this.setResultFailed(463, "sbbExceptionThrown does not have the ActivityContextInterface object from event-handler method that threw the exception");
                return;
            }
            this.setResultPassed("sbbExceptionThrown for non-transactional methods passed");
        }
        catch (Exception e) {
            TCKSbbUtils.handleException(e);
        }
        finally {
            this.event = null;
            this.aci = null;
        }
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    public abstract void setTestValue(int var1);

    public abstract int getTestValue();
}

