/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.abstractclass;

import com.opencloud.sleetck.lib.SleeTCKTest;
import com.opencloud.sleetck.lib.SleeTCKTestUtils;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.slee.management.DeploymentException;

public class Test2217Test
implements SleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 2217;
    private SleeTCKTestUtils utils;
    private TCKResourceListener resourceListener;
    private FutureResult result;

    public void init(SleeTCKTestUtils utils) {
        this.utils = utils;
    }

    public TCKTestResult run() throws Exception {
        block2: {
            String duPath = this.utils.getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
            try {
                this.utils.install(duPath);
            }
            catch (TCKTestErrorException e) {
                if (!e.getEnclosedException().getClass().equals(DeploymentException.class)) break block2;
                return TCKTestResult.passed();
            }
        }
        return TCKTestResult.failed(2217, "Was able to deploy an SBB containing an SBB Usage Interface that allowed both incrementFoo and sampleFoo.");
    }

    public void setUp() throws Exception {
        this.utils.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils.getResourceInterface().setResourceListener(this.resourceListener);
        this.utils.getLog().fine("Installing and activating service");
    }

    public void tearDown() throws Exception {
        this.utils.getLog().fine("Disconnecting from resource");
        this.utils.getResourceInterface().clearActivities();
        this.utils.getResourceInterface().removeResourceListener();
        this.utils.getLog().fine("Deactivating and uninstalling service");
        this.utils.deactivateAllServices();
        this.utils.uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            Test2217Test.this.utils.getLog().info("Received message from SBB.");
            if (passed.booleanValue()) {
                Test2217Test.this.result.setPassed();
            } else {
                Test2217Test.this.result.setFailed(2217, msgString);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test2217Test.this.utils.getLog().warning("Received exception from SBB");
            Test2217Test.this.utils.getLog().warning(e);
            Test2217Test.this.result.setError(e);
        }
    }
}

