/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.sbb.activitycontext;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ResourceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceManagementMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.TraceMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.SbbID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.management.ServiceState;
import javax.slee.resource.ResourceAdaptorID;

public class Test1106025Test
extends AbstractSleeTCKTest {
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    private static final int TEST_ID = 1106025;
    private TCKResourceListener resourceListener;
    private FutureResult result;
    private DeployableUnitID duID;
    private NotificationListener listener;
    private ObjectName traceMBeanName;
    private TraceMBeanProxy tracembean;
    private ResourceAdaptorID raID;
    private DeployableUnitID sbbDUID;
    private DeployableUnitID raDUID;
    private String bindLinkName = "slee/resources/tck/simple";
    private String raLinkName;
    private String raEntityName;
    private SbbID sbbID;
    private ServiceID serviceID;
    private ResourceManagementMBeanProxy resourceMBean;
    private TCKResourceTestInterface resource;

    public TCKTestResult run() throws Exception {
        this.result = new FutureResult(this.utils().getLog());
        this.resource = this.utils().getResourceInterface();
        TCKActivityID activityID = this.resource.createActivity("Test1106025InitialActivity");
        this.resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        return this.result.waitForResultOrFail(this.utils().getTestTimeout(), "Timeout waiting for test result.", 1106025);
    }

    public void setUp() throws Exception {
        DeploymentMBeanProxy deploymentMBean = this.utils().getDeploymentMBeanProxy();
        ServiceManagementMBeanProxy serviceMBean = this.utils().getServiceManagementMBeanProxy();
        String serviceDUPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        if (serviceDUPath != null) {
            DeployableUnitDescriptor descriptor = null;
            String absolutePath = this.utils().getDeploymentUnitURL(serviceDUPath);
            this.utils().getLog().info("Installing service: " + absolutePath);
            this.sbbDUID = deploymentMBean.install(absolutePath);
            try {
                descriptor = this.utils().getDeploymentMBeanProxy().getDescriptor(this.sbbDUID);
            }
            catch (Exception e) {
                throw new TCKTestErrorException("An error occured while attempting to find a ServiceID contained in DU: " + this.sbbDUID, e);
            }
            ComponentID[] components = descriptor.getComponents();
            for (int i = 0; i < components.length; ++i) {
                if (components[i] instanceof ServiceID) {
                    this.utils().getLog().fine("Setting serviceID value.");
                    this.serviceID = (ServiceID)components[i];
                    continue;
                }
                if (!(components[i] instanceof SbbID)) continue;
                this.utils().getLog().fine("Setting sbbID value.");
                this.sbbID = (SbbID)components[i];
            }
        }
        serviceMBean.activate(this.serviceID);
        this.utils().getLog().fine("SBB & RA are active");
        this.resourceListener = new TCKResourceListenerImpl();
        this.setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        try {
            this.utils().getResourceInterface().clearActivities();
            this.utils().getResourceInterface().removeResourceListener();
            try {
                ServiceState serviceState;
                DeploymentMBeanProxy deploymentMBean = this.utils().getDeploymentMBeanProxy();
                ServiceManagementMBeanProxy serviceMBean = this.utils().getServiceManagementMBeanProxy();
                this.utils().getLog().info("Deactivating Service: " + this.serviceID);
                serviceMBean.deactivate(this.serviceID);
                long timeout = System.currentTimeMillis() + (long)this.utils().getTestTimeout();
                while (System.currentTimeMillis() < timeout && !(serviceState = serviceMBean.getState(this.serviceID)).isInactive()) {
                    Thread.sleep(500L);
                }
                this.utils().getLog().info("Uninstall SBB: " + this.sbbDUID);
                deploymentMBean.uninstall(this.sbbDUID);
            }
            catch (Exception e) {
                this.utils().getLog().warning(e);
            }
            this.utils().uninstallAll();
        }
        catch (Exception e) {
            this.utils().getLog().warning(e);
            this.utils().getLog().warning("ERROR: problems in test tear down");
        }
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID calledActivity) throws RemoteException {
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            String msgString = (String)map.get("Message");
            Test1106025Test.this.utils().getLog().info("Received message from SBB.");
            if (passed.booleanValue()) {
                Test1106025Test.this.result.setPassed();
                Test1106025Test.this.getLog().info(msgString);
            } else {
                Test1106025Test.this.result.setFailed(1106025, msgString);
            }
        }

        public void onActivityEndedBySbb(TCKActivityID activityID) throws RemoteException {
            try {
                Test1106025Test.this.getLog().info("Received onActivityEndedBySbb message from SBB.");
                TCKActivityID activityID2 = Test1106025Test.this.resource.createActivity("Test1106025ActivityEnded");
                Test1106025Test.this.resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X2", activityID2, null);
            }
            catch (Exception e) {
                Test1106025Test.this.utils().getLog().warning("Exception Test1106025ActivityEnded");
                Test1106025Test.this.utils().getLog().warning(e);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test1106025Test.this.utils().getLog().warning("Received exception from SBB");
            Test1106025Test.this.utils().getLog().warning(e);
            Test1106025Test.this.result.setError(e);
        }

        public Object onSbbCall(Object argument) throws Exception {
            Test1106025Test.this.getLog().info((String)argument);
            return null;
        }
    }
}

