/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.transactions;

import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceListener;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.util.Future;
import java.rmi.RemoteException;

public class Test2508Test
extends AbstractSleeTCKTest {
    private boolean wasChildMethodCalled;
    private TCKResourceListener resourceListener;
    private FutureResult futureResult;

    public TCKTestResult run() throws Exception {
        this.futureResult = new FutureResult(this.getLog());
        this.getLog().info("Firing initial event to SBB");
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity("Test2508InitialActivity");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", "com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", activityID, null);
        try {
            return this.futureResult.waitForResult(this.utils().getTestTimeout());
        }
        catch (Future.TimeoutException e) {
            if (this.wasChildMethodCalled) {
                return TCKTestResult.failed(2510, "Timed out while waiting for the sbbRolledBack() method to be invoked on the parent SBB, following the invocation of a child sbb's local interface method which threw a RuntimeException");
            }
            return TCKTestResult.error("Timed out waiting for a message indicating that the TransactionRolledbackLocalException was caught as a result of the invocation of a child sbb's local interface method throwing a RuntimeException");
        }
    }

    public void setUp() throws Exception {
        this.wasChildMethodCalled = false;
        this.getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils().getResourceInterface().setResourceListener(this.resourceListener);
        super.setUp();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage sbbMessage, TCKActivityID calledActivity) throws RemoteException {
            String message = (String)sbbMessage.getMessage();
            if ("PARENT_CALLED_CHILD".equals(message)) {
                Test2508Test.this.getLog().info("Received indication that the child's local interface method was invoked, and that the TransactionRolledbackLocalException was caught");
                Test2508Test.this.wasChildMethodCalled = true;
            } else if ("SBB_EXCEPTION_THROWN_CHILD".equals(message)) {
                Test2508Test.this.futureResult.setFailed(2508, "The sbbExceptionThrown() method was invoked on an SBB as a result of one of its local interface methods throwing a RuntimeException");
            } else if ("SBB_ROLLED_BACK_CHILD".equals(message)) {
                Test2508Test.this.futureResult.setFailed(2509, "The sbbRolledBack() method was invoked on an SBB after of one of its local interface methods threw a RuntimeException");
            } else if ("SBB_EXCEPTION_THROWN_PARENT".equals(message)) {
                Test2508Test.this.futureResult.setFailed(2508, "The sbbExceptionThrown() method was invoked on a calling SBB as a result of it calling a local interface method on a child SBB, and that method throwing a RuntimeException");
            } else if ("SBB_ROLLED_BACK_PARENT".equals(message)) {
                if (Test2508Test.this.wasChildMethodCalled) {
                    Test2508Test.this.getLog().info("The sbbRolledBack() method was invoked on the parent SBB as expected.");
                    Test2508Test.this.futureResult.setPassed();
                } else {
                    Test2508Test.this.futureResult.setError("The sbbRolledBack() method was invoked on the parent SBB as expected, but the test never received an indication that the local interface method's RuntimeException was processed. (The test never received the expected message indicating that the TransactionRolledbackLocalException was caught)");
                }
            } else {
                Test2508Test.this.futureResult.setError("Unexpected message received from SBB: " + message);
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test2508Test.this.getLog().warning("Received exception from SBB");
            Test2508Test.this.getLog().warning(e);
            Test2508Test.this.futureResult.setError(e);
        }
    }
}

