/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.profiles;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.AbstractSleeTCKTest;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileProvisioningMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileTableUsageMBeanProxy;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.management.DeployableUnitID;
import javax.slee.profile.ProfileSpecificationID;

public abstract class BaseProfileTest
extends AbstractSleeTCKTest {
    public static final String TCK_SBB_EVENT_DU_PATH_PARAM = "eventDUPath";
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    public static final String PARAM_SET_NAME = "FooParameterSet";
    protected ProfileProvisioningMBeanProxy profileProxy;
    protected DeployableUnitID duID;
    protected Logable log;

    protected void createProfileTable(String tableName) throws Exception {
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profSpecID = (ProfileSpecificationID)components[i];
            this.profileProxy.createProfileTable(profSpecID, tableName);
            this.log.fine("Created profile table " + tableName + " for profile specification " + profSpecID.getName() + " " + profSpecID.getVersion() + ", " + profSpecID.getVendor());
        }
    }

    protected void removeProfileTable(String tableName) {
        try {
            this.profileProxy.removeProfileTable(tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createProfile(String tableName, String profileName) throws Exception {
        ObjectName profile = this.profileProxy.createProfile(tableName, profileName);
        ProfileMBeanProxy proxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        this.log.fine("Created profile " + profileName + " for profile table " + tableName);
        proxy.commitProfile();
        proxy.closeProfile();
        this.log.fine("Committed and closed profile.");
    }

    protected void removeProfile(String profileTableName, String profileName) {
        try {
            this.profileProxy.removeProfile(profileTableName, profileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createNamedParameterSet(String tableName) throws TCKTestErrorException {
        try {
            ObjectName profileTableUsageMBeanName = this.profileProxy.getProfileTableUsageMBean(tableName);
            ProfileTableUsageMBeanProxy p = this.utils().getMBeanProxyFactory().createProfileTableUsageMBeanProxy(profileTableUsageMBeanName);
            p.createUsageParameterSet(PARAM_SET_NAME);
            p.close();
        }
        catch (Exception e) {
            throw new TCKTestErrorException("Could not create named parameter set", e);
        }
    }

    protected void removeNamedParameterSet(String tableName) throws TCKTestErrorException {
        try {
            ObjectName profileTableUsageMBeanName = this.profileProxy.getProfileTableUsageMBean(tableName);
            ProfileTableUsageMBeanProxy p = this.utils().getMBeanProxyFactory().createProfileTableUsageMBeanProxy(profileTableUsageMBeanName);
            p.removeUsageParameterSet(PARAM_SET_NAME);
            p.close();
        }
        catch (Exception e) {
            throw new TCKTestErrorException("Could not remove named parameter set", e);
        }
    }

    public void setUp() throws Exception {
        this.log = this.utils().getLog();
        super.setupService(TCK_SBB_EVENT_DU_PATH_PARAM);
        this.duID = super.setupService(SERVICE_DU_PATH_PARAM);
        this.profileProxy = new ProfileUtils(this.utils()).getProfileProvisioningProxy();
    }
}

