/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.profiles;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanProxyImpl;
import com.opencloud.sleetck.lib.testsuite.usage.profiles.BaseProfileTest;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.ProfileUtils;
import com.opencloud.sleetck.lib.testutils.jmx.DeploymentMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileTableUsageMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.management.DeployableUnitDescriptor;
import javax.slee.profile.ProfileSpecificationID;

public class Test1111008Test
extends BaseProfileTest {
    public static final String TCK_SBB_EVENT_DU_PATH_PARAM = "eventDUPath";
    private static final String SERVICE_DU_PATH_PARAM = "DUPath";
    public static final String PROFILE_TABLE_NAME = "Test1111008ProfileTable";
    public static final String PROFILE_NAME = "Test1111008Profile";
    private static final int TEST_ID = 1111008;
    private TCKResourceListenerImpl resourceListener;
    private FutureResult result;

    public TCKTestResult run() throws Exception {
        Logable log = this.utils().getLog();
        this.result = new FutureResult(log);
        DeploymentMBeanProxy duProxy = this.utils().getDeploymentMBeanProxy();
        DeployableUnitDescriptor duDesc = duProxy.getDescriptor(this.duID);
        ComponentID[] components = duDesc.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof ProfileSpecificationID)) continue;
            ProfileSpecificationID profSpecID = (ProfileSpecificationID)components[i];
            this.profileProxy.createProfileTable(profSpecID, PROFILE_TABLE_NAME);
            log.fine("Created profile table Test1111008ProfileTable for profile specification " + profSpecID.getName() + " " + profSpecID.getVersion() + ", " + profSpecID.getVendor());
        }
        this.createNamedParameterSet(PROFILE_TABLE_NAME);
        ObjectName profile = this.profileProxy.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        ProfileMBeanProxy proxy = this.utils().getMBeanProxyFactory().createProfileMBeanProxy(profile);
        log.fine("Created profile Test1111008Profile for profile table Test1111008ProfileTable");
        proxy.commitProfile();
        proxy.closeProfile();
        log.fine("Committed and closed profile.");
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(this.getClass().getName());
        this.getLog().fine("About to fire named usage parameter update request to SBB");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activityID, null);
        this.getLog().fine("Waiting for result");
        return this.result.waitForResult(5000L);
    }

    public void setUp() throws Exception {
        this.getLog().fine("Installing TCKSbbEvent deployable unit");
        String eventDUPath = this.utils().getTestParams().getProperty(TCK_SBB_EVENT_DU_PATH_PARAM);
        this.utils().install(eventDUPath);
        this.utils().getLog().fine("Installing and activating service");
        String duPath = this.utils().getTestParams().getProperty(SERVICE_DU_PATH_PARAM);
        this.duID = this.utils().install(duPath);
        this.utils().activateServices(this.duID, true);
        this.profileProxy = new ProfileUtils(this.utils()).getProfileProvisioningProxy();
        this.utils().getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils().getResourceInterface().setResourceListener(this.resourceListener);
    }

    public void tearDown() throws Exception {
        try {
            this.profileProxy.removeProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.profileProxy.removeProfileTable(PROFILE_TABLE_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.utils().getLog().fine("Disconnecting from resource");
        this.utils().getResourceInterface().clearActivities();
        this.utils().getResourceInterface().removeResourceListener();
        this.utils().getLog().fine("Deactivating and uninstalling service");
        this.utils().deactivateAllServices();
        this.utils().uninstallAll();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID activity) throws RemoteException {
            Test1111008Test.this.utils().getLog().fine("Received message from SBB ");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            try {
                ObjectName profileTableUsageMBeanName = Test1111008Test.this.profileProxy.getProfileTableUsageMBean(Test1111008Test.PROFILE_TABLE_NAME);
                ProfileTableUsageMBeanProxy p = Test1111008Test.this.utils().getMBeanProxyFactory().createProfileTableUsageMBeanProxy(profileTableUsageMBeanName);
                ObjectName usageMBeanName = p.getUsageMBean(p.getUsageParameterSets()[0]);
                UsageMBeanProxyImpl u = new UsageMBeanProxyImpl(usageMBeanName, Test1111008Test.this.utils().getMBeanFacade());
                long count = u.getFirstCount(false);
            }
            catch (Exception e) {
                Test1111008Test.this.utils().getLog().error(e);
                Test1111008Test.this.result.setError(e);
                return;
            }
            if (passed.booleanValue()) {
                Test1111008Test.this.utils().getLog().fine((String)map.get("Msg"));
                Test1111008Test.this.result.setPassed();
            } else {
                Test1111008Test.this.result.setFailed(1111008, (String)map.get("Msg"));
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test1111008Test.this.utils().getLog().warning("Received exception from SBB.");
            Test1111008Test.this.utils().getLog().warning(e);
            Test1111008Test.this.result.setError(e);
        }
    }
}

