/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.profiles;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.resource.testapi.TCKResourceTestInterface;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanProxyImpl;
import com.opencloud.sleetck.lib.testsuite.usage.profiles.BaseProfileTest;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.jmx.ProfileTableUsageMBeanProxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.management.ObjectName;
import javax.slee.usage.SampleStatistics;

public class Test1111015Test
extends BaseProfileTest {
    public static final String TCK_SBB_EVENT_DU_PATH_PARAM = "eventDUPath";
    public static final String PROFILE_TABLE_NAME = "Test1111015ProfileTable";
    public static final String PROFILE_NAME = "Test1111015Profile";
    private static final int TEST_ID = 1111015;
    private TCKResourceListenerImpl resourceListener;
    private FutureResult result;

    public TCKTestResult run() throws Exception {
        Logable log = this.utils().getLog();
        this.result = new FutureResult(log);
        TCKResourceTestInterface resource = this.utils().getResourceInterface();
        TCKActivityID activityID = resource.createActivity(this.getClass().getName());
        this.getLog().fine("About to fire named usage parameter update request to SBB");
        resource.fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", null, activityID, null);
        this.getLog().fine("Waiting for result");
        return this.result.waitForResult(20000L);
    }

    public void setUp() throws Exception {
        try {
            super.setUp();
            this.createProfileTable(PROFILE_TABLE_NAME);
            this.createProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
            this.createNamedParameterSet(PROFILE_TABLE_NAME);
            this.setResourceListener(new TCKResourceListenerImpl());
        }
        catch (Exception e) {
            this.utils().getLog().error("Exception raised trying to install library" + e);
            throw new TCKTestErrorException("Failed to create Profiles");
        }
    }

    public void tearDown() throws Exception {
        this.removeNamedParameterSet(PROFILE_TABLE_NAME);
        this.removeProfile(PROFILE_TABLE_NAME, PROFILE_NAME);
        this.removeProfileTable(PROFILE_TABLE_NAME);
        super.tearDown();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID activity) throws RemoteException {
            Test1111015Test.this.utils().getLog().fine("Received message from SBB");
            HashMap map = (HashMap)message.getMessage();
            Boolean passed = (Boolean)map.get("Result");
            try {
                ObjectName profileTableUsageMBeanName = Test1111015Test.this.profileProxy.getProfileTableUsageMBean(Test1111015Test.PROFILE_TABLE_NAME);
                ProfileTableUsageMBeanProxy p = Test1111015Test.this.utils().getMBeanProxyFactory().createProfileTableUsageMBeanProxy(profileTableUsageMBeanName);
                ObjectName usageMBeanName = p.getUsageMBean(p.getUsageParameterSets()[0]);
                UsageMBeanProxyImpl u = new UsageMBeanProxyImpl(usageMBeanName, Test1111015Test.this.utils().getMBeanFacade());
                SampleStatistics stats = u.getTimeBetweenNewConnections(false);
            }
            catch (Exception e) {
                Test1111015Test.this.utils().getLog().error(e);
                Test1111015Test.this.result.setError(e);
                return;
            }
            if (passed.booleanValue()) {
                Test1111015Test.this.utils().getLog().fine((String)map.get("Msg"));
                Test1111015Test.this.result.setPassed();
            } else {
                Test1111015Test.this.result.setFailed(1111015, (String)map.get("Msg"));
            }
        }

        public void onException(Exception e) throws RemoteException {
            Test1111015Test.this.utils().getLog().warning("Received exception from SBB.");
            Test1111015Test.this.utils().getLog().warning(e);
            Test1111015Test.this.result.setError(e);
        }
    }
}

