/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.sbb;

import com.opencloud.sleetck.lib.OperationTimedOutException;
import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.resource.TCKActivityID;
import com.opencloud.sleetck.lib.resource.TCKSbbMessage;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageSbbInstructions;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanProxy;
import com.opencloud.sleetck.lib.testsuite.usage.common.UsageMBeanProxyImpl;
import com.opencloud.sleetck.lib.testsuite.usage.sbb.BaseUsageTest;
import com.opencloud.sleetck.lib.testutils.BaseTCKResourceListener;
import com.opencloud.sleetck.lib.testutils.FutureResult;
import com.opencloud.sleetck.lib.testutils.QueuingNotificationListener;
import com.opencloud.sleetck.lib.testutils.jmx.MBeanProxyFactory;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceUsageMBeanProxy;
import com.opencloud.sleetck.lib.testutils.jmx.UsageNotificationManagerMBeanProxy;
import java.rmi.RemoteException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.slee.InvalidStateException;
import javax.slee.SbbID;
import javax.slee.management.ManagementException;
import javax.slee.management.NotificationSource;
import javax.slee.management.SbbNotification;
import javax.slee.usage.SampleStatistics;
import javax.slee.usage.UsageNotification;
import javax.slee.usage.UsageOutOfRangeFilter;
import javax.slee.usage.UsageUpdatedFilter;

public class Test1111025Test
extends BaseUsageTest {
    public static final int TEST_ID = 1111025;
    public static final String PARAM_SET_NAME = "Param set name";
    private TCKResourceListenerImpl resourceListener;
    private SbbID sbbid;
    private MBeanProxyFactory proxyFactory;
    private FutureResult result;
    protected ServiceUsageMBeanProxy serviceUsage;
    private UsageMBeanProxy defaultUsage;
    private UsageMBeanProxy namedUsage;

    public TCKTestResult run() throws Exception {
        TCKActivityID activityID = this.utils().getResourceInterface().createActivity("token activity");
        this.defaultUsage = this.getSbbUsageMBean(null);
        this.namedUsage = this.getSbbUsageMBean(PARAM_SET_NAME);
        ObjectName n = this.defaultUsage.getUsageNotificationManagerMBean();
        UsageNotificationManagerMBeanProxy notifierMgr = this.proxyFactory.createUsageNotificationManagerMBeanProxy(n);
        if (notifierMgr.getFirstCountNotificationsEnabled()) {
            return TCKTestResult.failed(1111287, "Usage parameter should have defaulted to not enabled.");
        }
        notifierMgr.setFirstCountNotificationsEnabled(false);
        if (notifierMgr.getFirstCountNotificationsEnabled()) {
            return TCKTestResult.failed(1111027, "Setting notifications-enabled to false failed.");
        }
        notifierMgr.setFirstCountNotificationsEnabled(true);
        if (!notifierMgr.getFirstCountNotificationsEnabled()) {
            return TCKTestResult.failed(1111027, "Setting notifications-enabled to true failed.");
        }
        this.getLog().info("Testing on default parameter set.");
        QueuingNotificationListener notificationListener = new QueuingNotificationListener(this.utils());
        this.defaultUsage.addNotificationListener(notificationListener, null, null);
        this.fireInstructions(activityID, null);
        TCKTestResult result = this.checkNotification(notificationListener);
        this.defaultUsage.removeNotificationListener(notificationListener);
        if (null != result) {
            this.getLog().info("Default parameter sets failed...");
            return result;
        }
        long stats = this.defaultUsage.getFirstCount(false);
        if (stats != 3L) {
            return TCKTestResult.failed(1111025, "Usage parameter 'firstCount' had unexpected value:" + Long.valueOf(stats).toString());
        }
        stats = this.defaultUsage.getSecondCount(false);
        if (stats != 5L) {
            return TCKTestResult.failed(1111025, "Usage parameter 'secondCount' had unexpected value:" + Long.valueOf(stats).toString());
        }
        SampleStatistics sample = this.defaultUsage.getTimeBetweenNewConnections(false);
        if (sample.getSampleCount() != 1L) {
            return TCKTestResult.failed(1111025, "Usage parameter 'timeBetweenConnections' had unexpected value:" + Long.valueOf(sample.getSampleCount()).toString());
        }
        sample = this.defaultUsage.getTimeBetweenErrors(false);
        if (sample.getSampleCount() != 1L) {
            return TCKTestResult.failed(1111025, "Usage parameter 'timeBetweenErrors' had unexpected value:" + Long.valueOf(sample.getSampleCount()).toString());
        }
        this.defaultUsage.getFirstCount(true);
        stats = this.defaultUsage.getFirstCount(false);
        if (stats != 0L) {
            return TCKTestResult.failed(1111025, "Parameter did not reset to zero.");
        }
        this.getLog().info("Default parameter set seemed to work okay.");
        this.defaultUsage.resetAllUsageParameters();
        this.getLog().info("Testing on named parameter set.");
        notificationListener = new QueuingNotificationListener(this.utils());
        this.namedUsage.addNotificationListener(notificationListener, null, null);
        this.fireInstructions(activityID, PARAM_SET_NAME);
        result = this.checkNotification(notificationListener);
        this.namedUsage.removeNotificationListener(notificationListener);
        if (null != result) {
            this.getLog().info("Named parameter sets failed...");
            return result;
        }
        this.getLog().info("Named parameter set seemed to work okay.");
        this.namedUsage.resetAllUsageParameters();
        this.getLog().debug("Service is: " + this.services[0].toString());
        this.getLog().debug("sbbid is: " + this.sbbid.toString());
        SbbNotification usageSource = new SbbNotification(this.services[0], this.sbbid);
        this.getLog().info("Testing parameter filters");
        notificationListener = new QueuingNotificationListener(this.utils());
        UsageUpdatedFilter usageUpdatedFilter = new UsageUpdatedFilter((NotificationSource)usageSource, "firstCount");
        this.namedUsage.addNotificationListener(notificationListener, (NotificationFilter)usageUpdatedFilter, null);
        this.fireInstructions(activityID, PARAM_SET_NAME);
        result = this.checkNotification(notificationListener);
        if (null != result) {
            this.getLog().info("Filter tests failed...");
            return result;
        }
        this.namedUsage.removeNotificationListener(notificationListener);
        UsageOutOfRangeFilter usageOutOfRangeFilter = new UsageOutOfRangeFilter((NotificationSource)usageSource, "firstCount", 1L, 1L);
        notificationListener = new QueuingNotificationListener(this.utils());
        this.namedUsage.addNotificationListener(notificationListener, (NotificationFilter)usageOutOfRangeFilter, null);
        this.fireInstructions(activityID, PARAM_SET_NAME);
        try {
            Notification notification;
            while ("javax.slee.management.usage.sbb".equals((notification = notificationListener.nextNotification()).getType())) {
            }
            return TCKTestResult.failed(1111224, "UsageOutOfRangeFilter should not let this notification through.");
        }
        catch (OperationTimedOutException e) {
            try {
                this.namedUsage.close();
                return TCKTestResult.failed(1111277, "UsageMBean.close() should have thrown a InvalidStateException");
            }
            catch (InvalidStateException e2) {
                this.getLog().info("Filters seem to work okay.");
                this.namedUsage.removeNotificationListener(notificationListener);
                notifierMgr.close();
                this.defaultUsage.close();
                this.namedUsage.close();
                return TCKTestResult.passed();
            }
        }
    }

    private TCKTestResult checkNotification(QueuingNotificationListener l) throws ManagementException, TCKTestErrorException {
        SbbNotification sn;
        block19: {
            Notification notification;
            try {
                notification = l.nextNotification();
            }
            catch (OperationTimedOutException e) {
                return TCKTestResult.failed(new TCKTestFailureException(1111025, "Did not receive notification", e));
            }
            UsageNotification un = (UsageNotification)notification;
            sn = (SbbNotification)un.getNotificationSource();
            this.getLog().debug("Got notification:" + notification.toString());
            if ("firstCount".equals(un.getUsageParameterName())) {
                this.getLog().debug("Default parameter set, firstCount value from the notification is: " + un.getValue());
                this.getLog().debug("Default parameter set, firstCount value directly is: " + this.defaultUsage.getFirstCount(false));
                if (3L != un.getValue()) {
                    return TCKTestResult.failed(1111025, "firstCount parameter has unexpected value:" + Long.valueOf(un.getValue()).toString());
                }
            } else if ("secondCount".equals(un.getUsageParameterName())) {
                this.getLog().debug("Default parameter set, secondCount value from the notification is: " + un.getValue());
                this.getLog().debug("Default parameter set, secondCount value directly is: " + this.defaultUsage.getSecondCount(false));
                if (5L != un.getValue()) {
                    return TCKTestResult.failed(1111025, "secondCount parameter has unexpected value:" + Long.valueOf(un.getValue()).toString());
                }
            } else {
                return TCKTestResult.failed(1111025, "Usage parameter set name unknown." + un.getUsageParameterSetName());
            }
            if (null == un.getUsageParameterSetName()) {
                try {
                    if (!this.serviceUsage.getSbbUsageMBean(this.sbbid).equals(un.getSource())) {
                        return TCKTestResult.failed(1111025, "UsageNotification source for default set was not the expected value.");
                    }
                    break block19;
                }
                catch (Exception e) {
                    return TCKTestResult.error(e);
                }
            }
            if (PARAM_SET_NAME.equals(un.getUsageParameterSetName())) {
                try {
                    if (!this.serviceUsage.getSbbUsageMBean(this.sbbid, PARAM_SET_NAME).equals(un.getSource())) {
                        return TCKTestResult.failed(1111025, "UsageNotification source for named set was not the expected value.");
                    }
                    break block19;
                }
                catch (Exception e) {
                    return TCKTestResult.error(e);
                }
            }
            return TCKTestResult.failed(1111025, "Usage parameter set unknown:" + un.getUsageParameterSetName());
        }
        if (!"javax.slee.management.usage.sbb".equals(sn.getUsageNotificationType())) {
            return TCKTestResult.failed(1111025, "Usage Notification type was not what I expected.");
        }
        if (!sn.getSbb().equals((Object)this.sbbid)) {
            return TCKTestResult.failed(1111025, "Usage Notification SbbID was not what I expected.");
        }
        if (!sn.getService().equals((Object)this.services[0])) {
            return TCKTestResult.failed(1111025, "Usage Notification ServiceID was not what I expected.");
        }
        return null;
    }

    private UsageMBeanProxy getSbbUsageMBean(String paramSetName) throws TCKTestErrorException {
        try {
            ObjectName n = null == paramSetName ? this.serviceUsage.getSbbUsageMBean(this.sbbid) : this.serviceUsage.getSbbUsageMBean(this.sbbid, paramSetName);
            return new UsageMBeanProxyImpl(n, this.utils().getMBeanFacade());
        }
        catch (Exception e) {
            throw new TCKTestErrorException("Failed to get SBB usage proxy.", e);
        }
    }

    private void fireInstructions(TCKActivityID activityID, String paramSetName) throws TCKTestErrorException, RemoteException {
        GenericUsageSbbInstructions instr = new GenericUsageSbbInstructions(paramSetName);
        instr.addFirstCountIncrement(3L);
        instr.addSecondCountIncrement(5L);
        instr.addTimeBetweenNewConnectionsSamples(7L);
        instr.addTimeBetweenErrorsSample(11L);
        this.getLog().info("firing event to Sbb");
        this.utils().getResourceInterface().fireEvent("com.opencloud.sleetck.lib.resource.events.TCKResourceEventX.X1", instr.toExported(), activityID, null);
    }

    public void setUp() throws Exception {
        super.setUp();
        boolean done = false;
        for (int i = 0; i < this.services.length; ++i) {
            if (done) {
                throw new TCKTestErrorException("There was more than one service in this test.");
            }
            ObjectName serviceUsageName = this.utils().getServiceManagementMBeanProxy().getServiceUsageMBean(this.services[i]);
            this.serviceUsage = this.utils().getMBeanProxyFactory().createServiceUsageMBeanProxy(serviceUsageName);
        }
        this.sbbid = new SbbID("GenericUsageSbb", "jain.slee.tck", "1.1");
        this.serviceUsage.createUsageParameterSet(this.sbbid, PARAM_SET_NAME);
        this.utils().getLog().fine("Connecting to resource");
        this.resourceListener = new TCKResourceListenerImpl();
        this.utils().getResourceInterface().setResourceListener(this.resourceListener);
        this.proxyFactory = this.utils().getMBeanProxyFactory();
    }

    private class TCKResourceListenerImpl
    extends BaseTCKResourceListener {
        private TCKResourceListenerImpl() {
        }

        public synchronized void onSbbMessage(TCKSbbMessage message, TCKActivityID activity) throws RemoteException {
            Test1111025Test.this.utils().getLog().fine("Received message from SBB: " + message.getMessage());
        }

        public void onException(Exception e) throws RemoteException {
            Test1111025Test.this.utils().getLog().warning("Received exception from SBB.");
            Test1111025Test.this.utils().getLog().warning(e);
            Test1111025Test.this.result.setError(e);
        }
    }
}

