/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testsuite.usage.sets;

import com.opencloud.sleetck.lib.TCKTestErrorException;
import com.opencloud.sleetck.lib.TCKTestFailureException;
import com.opencloud.sleetck.lib.TCKTestResult;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageMBeanLookup;
import com.opencloud.sleetck.lib.testsuite.usage.common.GenericUsageTest;
import com.opencloud.sleetck.lib.testutils.jmx.ServiceUsageMBeanProxy;
import java.util.Iterator;
import java.util.Vector;
import javax.management.ObjectName;
import javax.slee.InvalidArgumentException;
import javax.slee.SbbID;
import javax.slee.usage.UnrecognizedUsageParameterSetNameException;

public class UsageParameterSetNamesTest
extends GenericUsageTest {
    public static final int TEST_ID = 2486;

    public TCKTestResult run() throws Exception {
        GenericUsageMBeanLookup mBeanLookup = this.getGenericUsageMBeanLookup();
        SbbID sbbID = mBeanLookup.getSbbID();
        ServiceUsageMBeanProxy serviceUsageMBeanProxy = mBeanLookup.getServiceUsageMBeanProxy();
        try {
            serviceUsageMBeanProxy.createUsageParameterSet(sbbID, "foo");
        }
        catch (InvalidArgumentException e) {
            throw new TCKTestErrorException("Caught unexpected InvalidArgumentException when trying to create a usage parameter with a valid name. This may indicate an invalid SbbID or a error in the SLEE.", (Exception)((Object)e));
        }
        StringBuffer validNameBuf = new StringBuffer();
        for (char validChar = ' '; validChar < '~'; validChar = (char)(validChar + '\u0001')) {
            validNameBuf.append(validChar);
        }
        String validName = validNameBuf.toString();
        try {
            this.getLog().info("Attempting to create a usage parameter set name with the following valid name: " + validName);
            serviceUsageMBeanProxy.createUsageParameterSet(sbbID, validName);
            this.getLog().info("Attempting to access the SbbUsageMBean for the parameter set via getSbbUsageMBean() to test whether the creation was successful");
            ObjectName sbbUsageMBeanName = null;
            try {
                sbbUsageMBeanName = serviceUsageMBeanProxy.getSbbUsageMBean(sbbID, validName);
            }
            catch (UnrecognizedUsageParameterSetNameException e) {
                throw new TCKTestFailureException(2486, "Failed to create a usage parameter set with the following valid name: " + validName + ". createUsageParameterSet() threw no Exception, " + "but getSbbUsageMBean() threw an UnrecognizedUsageParameterSetNameException for the named usage parameter set.");
            }
            if (sbbUsageMBeanName == null) {
                throw new TCKTestFailureException(2486, "Failed to create a usage parameter set with the following valid name: " + validName + ". createUsageParameterSet() threw no Exception, " + "but getSbbUsageMBean() returned a null ObjectName for the named usage parameter set.");
            }
            this.getLog().info("getSbbUsageMBean() returned a non-null ObjectName: " + sbbUsageMBeanName);
        }
        catch (InvalidArgumentException e) {
            throw new TCKTestFailureException(2486, "Caught unexpected InvalidArgumentException when trying to create a usage parameter with the following valid name: " + validName, (Exception)((Object)e));
        }
        Vector<Character> invalidCharacters = new Vector<Character>();
        for (char invalidChar = '\u0000'; invalidChar < '\u001f'; invalidChar = (char)(invalidChar + '\u0001')) {
            invalidCharacters.addElement(new Character(invalidChar));
        }
        invalidCharacters.addElement(new Character('\u007f'));
        Iterator invalidCharactersIter = invalidCharacters.iterator();
        while (invalidCharactersIter.hasNext()) {
            Character invalidCharacter = (Character)invalidCharactersIter.next();
            char unicodeValue = invalidCharacter.charValue();
            try {
                serviceUsageMBeanProxy.createUsageParameterSet(sbbID, invalidCharacter.toString());
                return TCKTestResult.failed(2486, "The SLEE did not throw the expected InvalidArgumentException when trying to create a usage parameter set with an invalid name. The invalid name was a single character of unicode value " + unicodeValue);
            }
            catch (InvalidArgumentException e) {
                this.getLog().info("Caught expected InvalidArgumentException for an invalid parameter set name with a character of unicode value " + unicodeValue + ". Error message: " + e.getMessage());
            }
        }
        return TCKTestResult.passed();
    }
}

