/*
 * Decompiled with CFR 0.152.
 */
package com.opencloud.sleetck.lib.testutils.statetracking;

import com.opencloud.logging.Logable;
import com.opencloud.sleetck.lib.testutils.statetracking.StateMachineTrackerUtil;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.slee.management.SleeState;
import javax.slee.management.SleeStateChangeNotification;

public class TrackingStateNotificationsListener
implements NotificationListener {
    private StateMachineTrackerUtil stateTracker;
    private Logable log;

    public TrackingStateNotificationsListener(StateMachineTrackerUtil stateMachineTrackerUtil, Logable logable) {
        this.stateTracker = stateMachineTrackerUtil;
        this.log = logable;
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification instanceof SleeStateChangeNotification) {
            SleeState sleeState = ((SleeStateChangeNotification)notification).getNewState();
            SleeState sleeState2 = ((SleeStateChangeNotification)notification).getOldState();
            this.log.finer("StateNotificationsListener:received state change to " + sleeState + " from " + sleeState2);
            this.stateTracker.shiftState(sleeState.toInt());
        }
    }
}

