/*
 * Decompiled with CFR 0.152.
 */
package com.openfaas.entrypoint;

import com.openfaas.entrypoint.HandlerProvider;
import com.openfaas.model.AbstractHandler;
import com.openfaas.model.IHandler;
import com.openfaas.model.IRequest;
import com.openfaas.model.IResponse;
import com.openfaas.model.Request;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class App {
    public static void main(String[] args) throws Exception {
        int port = 8082;
        HandlerProvider p = HandlerProvider.getInstance();
        AbstractHandler handler = p.getHandler();
        HttpServer server = HttpServer.create(new InetSocketAddress(port), 0);
        InvokeHandler invokeHandler = new InvokeHandler((IHandler)handler);
        server.createContext("/", invokeHandler);
        server.setExecutor(null);
        server.start();
    }

    static class InvokeHandler
    implements HttpHandler {
        IHandler handler;

        private InvokeHandler(IHandler handler) {
            this.handler = handler;
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            Object buffer;
            String requestBody = "";
            String method = t.getRequestMethod();
            if (method.equalsIgnoreCase("POST")) {
                int length;
                InputStream inputStream = t.getRequestBody();
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                buffer = new byte[1024];
                while ((length = inputStream.read((byte[])buffer)) != -1) {
                    result.write((byte[])buffer, 0, length);
                }
                requestBody = result.toString("UTF-8");
            }
            Headers reqHeaders = t.getRequestHeaders();
            HashMap<String, String> reqHeadersMap = new HashMap<String, String>();
            buffer = reqHeaders.entrySet().iterator();
            while (buffer.hasNext()) {
                Map.Entry header = (Map.Entry)buffer.next();
                List headerValues = (List)header.getValue();
                if (headerValues.size() <= 0) continue;
                reqHeadersMap.put((String)header.getKey(), (String)headerValues.get(0));
            }
            Request req = new Request(requestBody, reqHeadersMap, t.getRequestURI().getRawQuery(), t.getRequestURI().getPath());
            IResponse res = this.handler.Handle((IRequest)req);
            String response = res.getBody();
            byte[] bytesOut = response.getBytes("UTF-8");
            Headers responseHeaders = t.getResponseHeaders();
            String contentType = res.getContentType();
            if (contentType.length() > 0) {
                responseHeaders.set("Content-Type", contentType);
            }
            for (Map.Entry entry : res.getHeaders().entrySet()) {
                responseHeaders.set((String)entry.getKey(), (String)entry.getValue());
            }
            t.sendResponseHeaders(res.getStatusCode(), bytesOut.length);
            OutputStream os = t.getResponseBody();
            os.write(bytesOut);
            os.close();
            System.out.println("Request / " + Integer.toString(bytesOut.length) + " bytes written.");
        }
    }
}

